/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.firebird.model.plan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.jkiss.dbeaver.ext.firebird.model.plan.FireBirdPlanException;
import org.jkiss.dbeaver.ext.firebird.model.plan.FireBirdPlanToken;

class FireBirdPlanTokenMatcher {
    private List<Matcher> matchers = new ArrayList<Matcher>(FireBirdPlanToken.values().length);
    private Map<Matcher, FireBirdPlanToken> matchertokens = new HashMap<Matcher, FireBirdPlanToken>(FireBirdPlanToken.values().length);
    private int position = 0;
    FireBirdPlanToken token;
    private String value;
    private String subject;

    public FireBirdPlanTokenMatcher(String subject) {
        this.subject = subject;
        for (FireBirdPlanToken token : FireBirdPlanToken.values()) {
            Matcher matcher = token.newMatcher(subject);
            this.matchers.add(matcher);
            this.matchertokens.put(matcher, token);
        }
    }

    FireBirdPlanToken getToken() {
        return this.token;
    }

    String getValue() {
        return this.value;
    }

    void find() {
        for (Matcher matcher : this.matchers) {
            if (!matcher.find(this.position)) continue;
            this.position += matcher.group().length();
            this.token = this.matchertokens.get(matcher);
            this.value = matcher.group();
            return;
        }
        this.token = FireBirdPlanToken.IDENTIFICATOR;
        this.value = "???";
    }

    void jump() {
        do {
            this.find();
        } while (this.token == FireBirdPlanToken.WHITESPACE);
    }

    void checkToken(FireBirdPlanToken expected) throws FireBirdPlanException {
        if (expected != this.token) {
            this.raisePlanTokenException(expected, this.token);
        }
    }

    void raisePlanTokenException(FireBirdPlanToken expected, FireBirdPlanToken actual) throws FireBirdPlanException {
        throw new FireBirdPlanException(expected.toString(), actual.toString(), this.position - this.value.length(), this.subject);
    }

    void raisePlanTokenException() throws FireBirdPlanException {
        throw new FireBirdPlanException(this.token.toString(), this.position - this.value.length(), this.subject);
    }
}

