/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.log;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.log.StdErrLog;

public class StacklessLogging
implements AutoCloseable {
    private final Set<StdErrLog> squelched = new HashSet<StdErrLog>();

    public StacklessLogging(Class<?> ... classesToSquelch) {
        for (Class<?> clazz : classesToSquelch) {
            StdErrLog stdErrLog;
            Logger log2 = Log.getLogger(clazz);
            if (!(log2 instanceof StdErrLog) || log2.isDebugEnabled() || (stdErrLog = (StdErrLog)log2).isHideStacks()) continue;
            stdErrLog.setHideStacks(true);
            this.squelched.add(stdErrLog);
        }
    }

    public StacklessLogging(Logger ... logs) {
        for (Logger log2 : logs) {
            StdErrLog stdErrLog;
            if (!(log2 instanceof StdErrLog) || log2.isDebugEnabled() || (stdErrLog = (StdErrLog)log2).isHideStacks()) continue;
            stdErrLog.setHideStacks(true);
            this.squelched.add(stdErrLog);
        }
    }

    @Override
    public void close() {
        for (StdErrLog log2 : this.squelched) {
            log2.setHideStacks(false);
        }
    }
}

