/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.drawing.eps;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.klimt.drawing.eps.EpsGraphics;
import net.sourceforge.plantuml.klimt.drawing.eps.PostScriptCommandCurveTo;
import net.sourceforge.plantuml.klimt.drawing.eps.PostScriptCommandLineTo;
import net.sourceforge.plantuml.klimt.drawing.eps.PostScriptCommandMacro;
import net.sourceforge.plantuml.klimt.drawing.eps.PostScriptCommandMoveTo;
import net.sourceforge.plantuml.klimt.drawing.eps.PostScriptCommandQuadTo;
import net.sourceforge.plantuml.klimt.drawing.eps.PostScriptCommandRaw;
import net.sourceforge.plantuml.klimt.drawing.eps.PostScriptData;

public class EpsGraphicsMacro
extends EpsGraphics {
    private final PostScriptData data = new PostScriptData();
    private final PostScriptCommandMacro rquadto = new PostScriptCommandMacro("rquadto");
    private double posX;
    private double posY;
    private int macroCpt;
    private final Map<PostScriptCommandMacro, String> macros = new HashMap<PostScriptCommandMacro, String>();
    private PostScriptCommandMacro macroInProgress = null;

    public EpsGraphicsMacro() {
        this.rquadto.add(new PostScriptCommandRaw("3 index 3 index 4 2 roll rcurveto", true));
    }

    @Override
    protected void append(String s, boolean checkConsistence) {
        if (checkConsistence && s.indexOf("  ") != -1) {
            throw new IllegalArgumentException(s);
        }
        this.data.add(new PostScriptCommandRaw(s, checkConsistence));
    }

    @Override
    protected String getBodyString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.rquadto.getPostStringDefinition());
        for (PostScriptCommandMacro macro : this.macros.keySet()) {
            sb.append(macro.getPostStringDefinition());
        }
        sb.append(this.data.toPostString());
        return sb.toString();
    }

    @Override
    public void newpath() {
        this.append("0 setlinewidth", true);
        this.append("[] 0 setdash", true);
        this.appendColor(this.getColor());
        this.append("newpath", true);
    }

    @Override
    public void closepath() {
        this.macroInProgress.add(new PostScriptCommandRaw("closepath", true));
        this.closeMacro();
    }

    @Override
    public void fill(int windingRule) {
        if (this.macroInProgress != null) {
            this.closeMacro();
        }
        if (windingRule == 0) {
            this.append("eofill", true);
        } else if (windingRule == 1) {
            this.append("fill", true);
        }
    }

    @Override
    public void moveto(double x1, double y1) {
        this.data.add(new PostScriptCommandMoveTo(x1, y1));
        this.posX = x1;
        this.posY = y1;
        this.openMacro();
        this.ensureVisible(x1, y1);
    }

    @Override
    public void lineto(double x1, double y1) {
        PostScriptCommandLineTo cmd = new PostScriptCommandLineTo(x1 - this.posX, y1 - this.posY);
        this.macroInProgress.add(cmd);
        this.posX = x1;
        this.posY = y1;
        this.ensureVisible(x1, y1);
    }

    @Override
    public void curveto(double x1, double y1, double x2, double y2, double x3, double y3) {
        PostScriptCommandCurveTo cmd = new PostScriptCommandCurveTo(x1 - this.posX, y1 - this.posY, x2 - this.posX, y2 - this.posY, x3 - this.posX, y3 - this.posY);
        this.macroInProgress.add(cmd);
        this.posX = x3;
        this.posY = y3;
        this.ensureVisible(x1, y1);
        this.ensureVisible(x2, y2);
        this.ensureVisible(x3, y3);
    }

    @Override
    public void quadto(double x1, double y1, double x2, double y2) {
        PostScriptCommandQuadTo cmd = new PostScriptCommandQuadTo(x1 - this.posX, y1 - this.posY, x2 - this.posX, y2 - this.posY);
        this.macroInProgress.add(cmd);
        this.posX = x2;
        this.posY = y2;
        this.ensureVisible(x1, y1);
        this.ensureVisible(x2, y2);
    }

    private void openMacro() {
        if (this.macroInProgress != null) {
            throw new IllegalStateException();
        }
        this.macroInProgress = new PostScriptCommandMacro(this.macroName());
    }

    private String macroName() {
        return "P$" + Integer.toString(this.macroCpt, 36);
    }

    private void closeMacro() {
        if (this.macroInProgress == null) {
            throw new IllegalStateException();
        }
        String existingName = this.macros.get(this.macroInProgress);
        if (existingName == null) {
            this.macros.put(this.macroInProgress, this.macroInProgress.getName());
            this.append(this.macroName(), true);
            ++this.macroCpt;
        } else {
            this.append(existingName, true);
        }
        this.macroInProgress = null;
    }

    @Override
    protected void epsHLine(double x, double ymin, double ymax) {
        this.append(EpsGraphicsMacro.format(x) + " " + EpsGraphicsMacro.format(ymin) + " moveto", true);
        long diff = (long)((ymax - ymin) * 100.0);
        long nb = diff / (this.getDashVisible() + this.getDashSpace());
        long lastY = (long)(ymin * 100.0) + nb * (this.getDashVisible() + this.getDashSpace());
        long v = (long)(ymax * 100.0) - lastY;
        if (v > this.getDashVisible()) {
            ++nb;
            v = 0L;
        }
        this.append(nb + "{", true);
        this.append("0 " + this.getDashVisible() + " rlineto", true);
        this.append("0 " + this.getDashSpace() + " rmoveto", true);
        this.append("} repeat", true);
        if (v > 0L) {
            this.append("0 " + v + " rlineto", true);
        }
    }

    @Override
    protected void epsVLine(double y, double xmin, double xmax) {
        this.append(EpsGraphicsMacro.format(xmin) + " " + EpsGraphicsMacro.format(y) + " moveto", true);
        long diff = (long)((xmax - xmin) * 100.0);
        long nb = diff / (this.getDashVisible() + this.getDashSpace());
        long lastX = (long)(xmin * 100.0) + nb * (this.getDashVisible() + this.getDashSpace());
        long v = (long)(xmax * 100.0) - lastX;
        if (v > this.getDashVisible()) {
            ++nb;
            v = 0L;
        }
        this.append(nb + "{", true);
        this.append("" + this.getDashVisible() + " 0 rlineto", true);
        this.append("" + this.getDashSpace() + " 0 rmoveto", true);
        this.append("} repeat", true);
        if (v > 0L) {
            this.append(v + " 0 rlineto", true);
        }
    }
}

