/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessLogDeliveryStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifiedAccessLogS3Destination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VerifiedAccessLogS3Destination> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(VerifiedAccessLogS3Destination.getter(VerifiedAccessLogS3Destination::enabled)).setter(VerifiedAccessLogS3Destination.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").unmarshallLocationName("enabled").build()}).build();
    private static final SdkField<VerifiedAccessLogDeliveryStatus> DELIVERY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeliveryStatus").getter(VerifiedAccessLogS3Destination.getter(VerifiedAccessLogS3Destination::deliveryStatus)).setter(VerifiedAccessLogS3Destination.setter(Builder::deliveryStatus)).constructor(VerifiedAccessLogDeliveryStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStatus").unmarshallLocationName("deliveryStatus").build()}).build();
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketName").getter(VerifiedAccessLogS3Destination.getter(VerifiedAccessLogS3Destination::bucketName)).setter(VerifiedAccessLogS3Destination.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").unmarshallLocationName("bucketName").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Prefix").getter(VerifiedAccessLogS3Destination.getter(VerifiedAccessLogS3Destination::prefix)).setter(VerifiedAccessLogS3Destination.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").unmarshallLocationName("prefix").build()}).build();
    private static final SdkField<String> BUCKET_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketOwner").getter(VerifiedAccessLogS3Destination.getter(VerifiedAccessLogS3Destination::bucketOwner)).setter(VerifiedAccessLogS3Destination.setter(Builder::bucketOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketOwner").unmarshallLocationName("bucketOwner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, DELIVERY_STATUS_FIELD, BUCKET_NAME_FIELD, PREFIX_FIELD, BUCKET_OWNER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VerifiedAccessLogS3Destination.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final VerifiedAccessLogDeliveryStatus deliveryStatus;
    private final String bucketName;
    private final String prefix;
    private final String bucketOwner;

    private VerifiedAccessLogS3Destination(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.deliveryStatus = builder.deliveryStatus;
        this.bucketName = builder.bucketName;
        this.prefix = builder.prefix;
        this.bucketOwner = builder.bucketOwner;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final VerifiedAccessLogDeliveryStatus deliveryStatus() {
        return this.deliveryStatus;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final String prefix() {
        return this.prefix;
    }

    public final String bucketOwner() {
        return this.bucketOwner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketOwner());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedAccessLogS3Destination)) {
            return false;
        }
        VerifiedAccessLogS3Destination other = (VerifiedAccessLogS3Destination)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.deliveryStatus(), other.deliveryStatus()) && Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.bucketOwner(), other.bucketOwner());
    }

    public final String toString() {
        return ToString.builder((String)"VerifiedAccessLogS3Destination").add("Enabled", (Object)this.enabled()).add("DeliveryStatus", (Object)this.deliveryStatus()).add("BucketName", (Object)this.bucketName()).add("Prefix", (Object)this.prefix()).add("BucketOwner", (Object)this.bucketOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "DeliveryStatus": {
                return Optional.ofNullable(clazz.cast(this.deliveryStatus()));
            }
            case "BucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "Prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "BucketOwner": {
                return Optional.ofNullable(clazz.cast(this.bucketOwner()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Enabled", ENABLED_FIELD);
        map.put("DeliveryStatus", DELIVERY_STATUS_FIELD);
        map.put("BucketName", BUCKET_NAME_FIELD);
        map.put("Prefix", PREFIX_FIELD);
        map.put("BucketOwner", BUCKET_OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerifiedAccessLogS3Destination, T> g) {
        return obj -> g.apply((VerifiedAccessLogS3Destination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private VerifiedAccessLogDeliveryStatus deliveryStatus;
        private String bucketName;
        private String prefix;
        private String bucketOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedAccessLogS3Destination model) {
            this.enabled(model.enabled);
            this.deliveryStatus(model.deliveryStatus);
            this.bucketName(model.bucketName);
            this.prefix(model.prefix);
            this.bucketOwner(model.bucketOwner);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final VerifiedAccessLogDeliveryStatus.Builder getDeliveryStatus() {
            return this.deliveryStatus != null ? this.deliveryStatus.toBuilder() : null;
        }

        public final void setDeliveryStatus(VerifiedAccessLogDeliveryStatus.BuilderImpl deliveryStatus) {
            this.deliveryStatus = deliveryStatus != null ? deliveryStatus.build() : null;
        }

        @Override
        public final Builder deliveryStatus(VerifiedAccessLogDeliveryStatus deliveryStatus) {
            this.deliveryStatus = deliveryStatus;
            return this;
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getBucketOwner() {
            return this.bucketOwner;
        }

        public final void setBucketOwner(String bucketOwner) {
            this.bucketOwner = bucketOwner;
        }

        @Override
        public final Builder bucketOwner(String bucketOwner) {
            this.bucketOwner = bucketOwner;
            return this;
        }

        public VerifiedAccessLogS3Destination build() {
            return new VerifiedAccessLogS3Destination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VerifiedAccessLogS3Destination> {
        public Builder enabled(Boolean var1);

        public Builder deliveryStatus(VerifiedAccessLogDeliveryStatus var1);

        default public Builder deliveryStatus(Consumer<VerifiedAccessLogDeliveryStatus.Builder> deliveryStatus) {
            return this.deliveryStatus((VerifiedAccessLogDeliveryStatus)((VerifiedAccessLogDeliveryStatus.Builder)VerifiedAccessLogDeliveryStatus.builder().applyMutation(deliveryStatus)).build());
        }

        public Builder bucketName(String var1);

        public Builder prefix(String var1);

        public Builder bucketOwner(String var1);
    }
}

