/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.alerting.AlertService;
import org.opensearch.alerting.MonitorRunnerService;
import org.opensearch.alerting.model.destination.Destination;
import org.opensearch.alerting.util.DestinationType;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.alerting.model.AggregationResultBucket;
import org.opensearch.commons.alerting.model.BucketLevelTrigger;
import org.opensearch.commons.alerting.model.BucketLevelTriggerRunResult;
import org.opensearch.commons.alerting.model.DocumentLevelTrigger;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.model.Trigger;
import org.opensearch.commons.alerting.model.action.Action;
import org.opensearch.commons.alerting.model.action.ActionExecutionPolicy;
import org.opensearch.commons.alerting.model.action.ActionExecutionScope;
import org.opensearch.commons.alerting.util.IndexUtilsKt;
import org.opensearch.script.Script;

@kotlin.Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0098\u0001\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a6\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00012\u000e\u0010\u000f\u001a\n\u0018\u00010\u0010j\u0004\u0018\u0001`\u0011\u001a\u0014\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0014\u001a\u0006\u0010\u0015\u001a\u00020\n\u001a\u001e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\f\u001a\u000e\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\f\u001a\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0014\u001a\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u001f2\u0006\u0010\"\u001a\u00020#\u001a\u000e\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020!\u001a\u0014\u0010&\u001a\u00020'*\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*\u001a\u0014\u0010+\u001a\u0004\u0018\u00010,*\u00020-2\u0006\u0010.\u001a\u00020/\u001a\n\u0010\u0012\u001a\u00020\f*\u000200\u001a\u0014\u00101\u001a\u000202*\u0002022\b\u00103\u001a\u0004\u0018\u000102\u001a\u0018\u00104\u001a\u00020\b*\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u00020\f0\u0014\u001a\n\u00107\u001a\u00020\b*\u00020/\u001a\n\u00108\u001a\u00020\b*\u00020/\u001a\n\u00109\u001a\u00020\b*\u000205\u001a9\u0010:\u001a\u0002H;\"\b\b\u0000\u0010<*\u00020(\"\u0004\b\u0001\u0010;*\u0002H<2\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u0002H<\u0012\u0004\u0012\u0002H;0>H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010?\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006@"}, d2={"MAX_SEARCH_SIZE", "", "getMAX_SEARCH_SIZE", "()I", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "defaultToPerExecutionAction", "", "maxActionableAlertCount", "", "monitorId", "", "triggerId", "totalActionableAlertCount", "monitorOrTriggerError", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getBucketKeysHash", "bucketKeys", "", "getCancelAfterTimeInterval", "getRoleFilterEnabled", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "settingPath", "isValidEmail", "email", "parseSampleDocTags", "", "triggers", "Lorg/opensearch/commons/alerting/model/Trigger;", "messageTemplate", "Lorg/opensearch/script/Script;", "printsSampleDocData", "trigger", "closeFinally", "", "Lorg/opensearch/common/util/concurrent/ThreadContext$StoredContext;", "cause", "", "getActionExecutionPolicy", "Lorg/opensearch/commons/alerting/model/action/ActionExecutionPolicy;", "Lorg/opensearch/commons/alerting/model/action/Action;", "monitor", "Lorg/opensearch/commons/alerting/model/Monitor;", "Lorg/opensearch/commons/alerting/model/AggregationResultBucket;", "getCombinedTriggerRunResult", "Lorg/opensearch/commons/alerting/model/BucketLevelTriggerRunResult;", "prevTriggerRunResult", "isAllowed", "Lorg/opensearch/alerting/model/destination/Destination;", "allowList", "isDocLevelMonitor", "isQueryLevelMonitor", "isTestAction", "use", "R", "T", "block", "Lkotlin/Function1;", "(Lorg/opensearch/common/util/concurrent/ThreadContext$StoredContext;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nAlertingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlertingUtils.kt\norg/opensearch/alerting/util/AlertingUtilsKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,290:1\n1313#2,2:291\n1360#3:293\n1446#3,2:294\n1360#3:296\n1446#3,5:297\n1448#3,3:302\n1747#3,2:305\n1747#3,3:307\n1749#3:310\n*S KotlinDebug\n*F\n+ 1 AlertingUtils.kt\norg/opensearch/alerting/util/AlertingUtilsKt\n*L\n238#1:291,2\n258#1:293\n258#1:294,2\n259#1:296\n259#1:297,5\n258#1:302,3\n269#1:305,2\n287#1:307,3\n269#1:310\n*E\n"})
public final class AlertingUtilsKt {
    private static final Logger logger = LogManager.getLogger((String)"AlertingUtils");
    private static final int MAX_SEARCH_SIZE = 10000;

    public static final int getMAX_SEARCH_SIZE() {
        return MAX_SEARCH_SIZE;
    }

    public static final boolean isValidEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Regex validEmailPattern = new Regex("(?:[a-z0-9!#$%&'*+\\/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+\\/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9]))\\.){3}(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9])|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])", RegexOption.IGNORE_CASE);
        return validEmailPattern.matches((CharSequence)email);
    }

    public static final boolean getRoleFilterEnabled(@NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull String settingPath) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)settingPath, (String)"settingPath");
        boolean adBackendRoleFilterEnabled = false;
        Metadata metaData = clusterService.state().metadata();
        if (clusterService.getClusterSettings().get(settingPath) == null) {
            return false;
        }
        Object object = clusterService.getClusterSettings().get(settingPath).getDefault(settings);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
        adBackendRoleFilterEnabled = (Boolean)object;
        if (metaData.transientSettings().get(settingPath) != null) {
            Boolean bl2 = metaData.transientSettings().getAsBoolean(settingPath, Boolean.valueOf(adBackendRoleFilterEnabled));
            Intrinsics.checkNotNull((Object)bl2);
            bl = bl2;
        } else if (metaData.persistentSettings().get(settingPath) != null) {
            Boolean bl3 = metaData.persistentSettings().getAsBoolean(settingPath, Boolean.valueOf(adBackendRoleFilterEnabled));
            Intrinsics.checkNotNull((Object)bl3);
            bl = bl3;
        } else {
            bl = adBackendRoleFilterEnabled;
        }
        return bl;
    }

    public static final boolean isAllowed(@NotNull Destination $this$isAllowed, @NotNull List<String> allowList) {
        Intrinsics.checkNotNullParameter((Object)$this$isAllowed, (String)"<this>");
        Intrinsics.checkNotNullParameter(allowList, (String)"allowList");
        return allowList.contains($this$isAllowed.getType().getValue());
    }

    public static final boolean isTestAction(@NotNull Destination $this$isTestAction) {
        Intrinsics.checkNotNullParameter((Object)$this$isTestAction, (String)"<this>");
        return $this$isTestAction.getType() == DestinationType.TEST_ACTION;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isDocLevelMonitor(@NotNull Monitor $this$isDocLevelMonitor) {
        Intrinsics.checkNotNullParameter((Object)$this$isDocLevelMonitor, (String)"<this>");
        if (!IndexUtilsKt.isMonitorOfStandardType((Monitor)$this$isDocLevelMonitor)) return false;
        String string = $this$isDocLevelMonitor.getMonitorType();
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        if (Monitor.MonitorType.valueOf((String)string2) != Monitor.MonitorType.DOC_LEVEL_MONITOR) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isQueryLevelMonitor(@NotNull Monitor $this$isQueryLevelMonitor) {
        Intrinsics.checkNotNullParameter((Object)$this$isQueryLevelMonitor, (String)"<this>");
        if (!IndexUtilsKt.isMonitorOfStandardType((Monitor)$this$isQueryLevelMonitor)) return false;
        String string = $this$isQueryLevelMonitor.getMonitorType();
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        if (Monitor.MonitorType.valueOf((String)string2) != Monitor.MonitorType.QUERY_LEVEL_MONITOR) return false;
        return true;
    }

    @NotNull
    public static final String getBucketKeysHash(@NotNull AggregationResultBucket $this$getBucketKeysHash) {
        Intrinsics.checkNotNullParameter((Object)$this$getBucketKeysHash, (String)"<this>");
        return AlertingUtilsKt.getBucketKeysHash($this$getBucketKeysHash.getBucketKeys());
    }

    @NotNull
    public static final String getBucketKeysHash(@NotNull List<String> bucketKeys) {
        Intrinsics.checkNotNullParameter(bucketKeys, (String)"bucketKeys");
        return CollectionsKt.joinToString$default((Iterable)bucketKeys, (CharSequence)"#", null, null, (int)0, null, null, (int)62, null);
    }

    @Nullable
    public static final ActionExecutionPolicy getActionExecutionPolicy(@NotNull Action $this$getActionExecutionPolicy, @NotNull Monitor monitor) {
        Intrinsics.checkNotNullParameter((Object)$this$getActionExecutionPolicy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        Object object = $this$getActionExecutionPolicy.getActionExecutionPolicy();
        if (object == null) {
            object = IndexUtilsKt.isBucketLevelMonitor((Monitor)monitor) ? ActionExecutionPolicy.Companion.getDefaultConfigurationForBucketLevelMonitor() : (AlertingUtilsKt.isDocLevelMonitor(monitor) ? ActionExecutionPolicy.Companion.getDefaultConfigurationForDocumentLevelMonitor() : null);
        }
        return object;
    }

    @NotNull
    public static final BucketLevelTriggerRunResult getCombinedTriggerRunResult(@NotNull BucketLevelTriggerRunResult $this$getCombinedTriggerRunResult, @Nullable BucketLevelTriggerRunResult prevTriggerRunResult) {
        Intrinsics.checkNotNullParameter((Object)$this$getCombinedTriggerRunResult, (String)"<this>");
        if (prevTriggerRunResult == null) {
            return $this$getCombinedTriggerRunResult;
        }
        Map mergedAggregationResultBuckets = MapsKt.plus((Map)prevTriggerRunResult.getAggregationResultBuckets(), (Map)$this$getCombinedTriggerRunResult.getAggregationResultBuckets());
        Map mergedActionResultsMap = MapsKt.toMutableMap((Map)MapsKt.plus((Map)prevTriggerRunResult.getActionResultsMap(), (Map)$this$getCombinedTriggerRunResult.getActionResultsMap()));
        Exception exception = $this$getCombinedTriggerRunResult.getError();
        if (exception == null) {
            exception = prevTriggerRunResult.getError();
        }
        Exception error = exception;
        return BucketLevelTriggerRunResult.copy$default((BucketLevelTriggerRunResult)$this$getCombinedTriggerRunResult, null, (Exception)error, (Map)mergedAggregationResultBuckets, (Map)mergedActionResultsMap, (int)1, null);
    }

    public static final boolean defaultToPerExecutionAction(long maxActionableAlertCount, @NotNull String monitorId, @NotNull String triggerId, int totalActionableAlertCount, @Nullable Exception monitorOrTriggerError) {
        Intrinsics.checkNotNullParameter((Object)monitorId, (String)"monitorId");
        Intrinsics.checkNotNullParameter((Object)triggerId, (String)"triggerId");
        if (monitorOrTriggerError != null) {
            logger.debug("Trigger [" + triggerId + "] in monitor [" + monitorId + "] encountered an error. Defaulting to [" + ActionExecutionScope.Type.PER_EXECUTION + "] for action execution to communicate error.");
            return true;
        }
        if (maxActionableAlertCount < 0L) {
            return false;
        }
        if ((long)totalActionableAlertCount > maxActionableAlertCount) {
            logger.debug("The total actionable alerts for trigger [" + triggerId + "] in monitor [" + monitorId + "] is [" + totalActionableAlertCount + "] which exceeds the maximum of [" + maxActionableAlertCount + "]. Defaulting to [" + ActionExecutionScope.Type.PER_EXECUTION + "] for action execution.");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T extends ThreadContext.StoredContext, R> R use(@NotNull T $this$use, @NotNull Function1<? super T, ? extends R> block) {
        Intrinsics.checkNotNullParameter($this$use, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$use = false;
        Throwable exception = null;
        try {
            Object object = block.invoke($this$use);
            return (R)object;
        }
        catch (Throwable e) {
            exception = e;
            throw e;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            AlertingUtilsKt.closeFinally($this$use, exception);
            InlineMarker.finallyEnd((int)1);
        }
    }

    public static final long getCancelAfterTimeInterval() {
        TimeValue timeValue = MonitorRunnerService.INSTANCE.getMonitorCtx().getCancelAfterTimeInterval();
        Intrinsics.checkNotNull((Object)timeValue);
        long givenInterval = timeValue.getMinutes();
        if (givenInterval == -1L) {
            return givenInterval;
        }
        return Math.max(givenInterval, AlertService.Companion.getALERTS_SEARCH_TIMEOUT().getMinutes());
    }

    public static final void closeFinally(@NotNull ThreadContext.StoredContext $this$closeFinally, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)$this$closeFinally, (String)"<this>");
        if (cause == null) {
            $this$closeFinally.close();
        } else {
            try {
                $this$closeFinally.close();
            }
            catch (Throwable closeException) {
                ExceptionsKt.addSuppressed((Throwable)cause, (Throwable)closeException);
            }
        }
    }

    @NotNull
    public static final Set<String> parseSampleDocTags(@NotNull Script messageTemplate) {
        Intrinsics.checkNotNullParameter((Object)messageTemplate, (String)"messageTemplate");
        String sampleBlockPrefix = "{{#sample_documents}}";
        String sampleBlockSuffix = "{{/sample_documents}}";
        String sourcePrefix = "_source.";
        Regex tagRegex = new Regex("\\{\\{([^{}]+)}}");
        Set tags = new LinkedHashSet();
        try {
            String string = messageTemplate.getIdOrCode();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdOrCode(...)");
            int blockStart = StringsKt.indexOf$default((CharSequence)string, (String)sampleBlockPrefix, (int)0, (boolean)false, (int)6, null);
            String string2 = messageTemplate.getIdOrCode();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdOrCode(...)");
            int blockEnd = StringsKt.indexOf$default((CharSequence)string2, (String)sampleBlockSuffix, (int)blockStart, (boolean)false, (int)4, null);
            while (blockStart != -1 && blockEnd != -1) {
                String string3 = messageTemplate.getIdOrCode();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getIdOrCode(...)");
                String string4 = string3.substring(blockStart, blockEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                String sampleBlock = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string4, (CharSequence)sampleBlockPrefix), (CharSequence)sampleBlockSuffix);
                Sequence $this$forEach$iv = Regex.findAll$default((Regex)tagRegex, (CharSequence)sampleBlock, (int)0, (int)2, null);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MatchResult match = (MatchResult)element$iv;
                    boolean bl = false;
                    String docField = ((Object)StringsKt.trim((CharSequence)((String)match.getGroupValues().get(1)))).toString();
                    if (!StringsKt.startsWith$default((String)docField, (String)sourcePrefix, (boolean)false, (int)2, null) || !(((CharSequence)(docField = StringsKt.removePrefix((String)docField, (CharSequence)sourcePrefix))).length() > 0)) continue;
                    tags.add(docField);
                }
                String string5 = messageTemplate.getIdOrCode();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getIdOrCode(...)");
                blockStart = StringsKt.indexOf$default((CharSequence)string5, (String)sampleBlockPrefix, (int)blockEnd, (boolean)false, (int)4, null);
                String string6 = messageTemplate.getIdOrCode();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getIdOrCode(...)");
                blockEnd = StringsKt.indexOf$default((CharSequence)string6, (String)sampleBlockSuffix, (int)blockStart, (boolean)false, (int)4, null);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to parse sample document fields.", (Throwable)e);
        }
        return tags;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<String> parseSampleDocTags(@NotNull List<? extends Trigger> triggers) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(triggers, (String)"triggers");
        Iterable $this$flatMap$iv = triggers;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$flatMapTo$iv$iv2;
            Trigger trigger = (Trigger)element$iv$iv;
            boolean bl = false;
            Iterable $this$flatMap$iv2 = trigger.getActions();
            boolean $i$f$flatMap2 = false;
            Iterable iterable2 = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                Action action = (Action)element$iv$iv2;
                boolean bl2 = false;
                Iterable list$iv$iv = AlertingUtilsKt.parseSampleDocTags(action.getMessageTemplate());
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public static final boolean printsSampleDocData(@NotNull Trigger trigger) {
        boolean bl;
        block11: {
            Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
            Iterable $this$any$iv = trigger.getActions();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block10: {
                        String string;
                        Action action = (Action)element$iv;
                        boolean bl3 = false;
                        Trigger trigger2 = trigger;
                        if (trigger2 instanceof BucketLevelTrigger) {
                            string = "{{ctx.newAlerts}}";
                        } else if (trigger2 instanceof DocumentLevelTrigger) {
                            string = "{{ctx.alerts}}";
                        } else {
                            return false;
                        }
                        String alertsField = string;
                        Object[] objectArray = new String[]{"{{ctx}}", alertsField, "sample_documents"};
                        List validTags = CollectionsKt.listOfNotNull((Object[])objectArray);
                        Iterable $this$any$iv2 = validTags;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                String tag = (String)element$iv2;
                                boolean bl4 = false;
                                String string2 = action.getMessageTemplate().getIdOrCode();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdOrCode(...)");
                                if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)tag, (boolean)false, (int)2, null)) continue;
                                bl2 = true;
                                break block10;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        return bl;
    }
}

