/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InterruptedIOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.NTFJMSConnectionGroup;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIoaqnfy;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.pool.OracleDataSource;
import oracle.net.ns.NetException;

class NTFJMSConnection
extends Thread
implements Monitor,
Diagnosable {
    private static final String CLASS_NAME = NTFJMSConnection.class.getName();
    private String jmsConnectionId;
    private String instanceName;
    private String serviceName;
    private String userName;
    private OpaqueString password;
    private Properties connectionProps;
    private String connClass;
    private ArrayList<String> listenerAddresses;
    private static final int MAX_NUMBER_OF_TRIES = 5;
    private Connection conn = null;
    private T4CTTIoaqnfy oaqnfy = null;
    private volatile boolean needToBeClosed = false;
    private boolean safeToClose = true;
    private int numberOfRegistrations = 0;
    private NTFJMSConnectionGroup connectionGroup = null;
    private final Monitor.CloseableLock monitorLock = Monitor.newDefaultLock();

    NTFJMSConnection(String jmsConnectionId, ArrayList<String> listenerAddresses, String instanceName, String serviceName, String userName, OpaqueString password, Properties _connectionProps, String connClass, int numberOfRegistrations) {
        this.userName = userName;
        this.password = password;
        this.connectionProps = _connectionProps;
        this.serviceName = serviceName;
        this.jmsConnectionId = jmsConnectionId;
        this.listenerAddresses = listenerAddresses;
        this.instanceName = instanceName;
        this.connClass = connClass;
        this.numberOfRegistrations = numberOfRegistrations;
        assert (listenerAddresses != null) : "listenerAddresses is null";
        assert (instanceName != null) : "instancename is null";
    }

    @Override
    public void run() {
        boolean reConnect = false;
        int conAttempt = 0;
        int errorCode = 0;
        for (int cnt = 0; cnt < 2 && !this.needToBeClosed; ++cnt) {
            try {
                if (cnt == 0 || reConnect) {
                    this.conn = this.getConnection(conAttempt);
                    this.oaqnfy = new T4CTTIoaqnfy((T4CConnection)this.conn, this.jmsConnectionId);
                }
                if (this.needToBeClosed) break;
                if (reConnect) {
                    reConnect = false;
                    cnt = 0;
                }
                try (Monitor.CloseableLock lock = ((T4CConnection)this.conn).acquireCloseableLock();){
                    this.oaqnfy.doRPC();
                    continue;
                }
            }
            catch (InterruptedIOException eIo) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "run", "connectionId={0}, userName={1}, connClass={2}, instanceName={3}. ", (String)null, eIo, (Object)this.jmsConnectionId, (Object)this.userName, (Object)this.connClass, (Object)this.instanceName);
                this.needToBeClosed = true;
                continue;
            }
            catch (Exception e) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "run", "connectionId={0}, userName={1}, connClass={2}, instanceName={3}. ", (String)null, e, (Object)this.jmsConnectionId, (Object)this.userName, (Object)this.connClass, (Object)this.instanceName);
                if (this.needToBeClosed) break;
                if (reConnect) {
                    this.getConnectionGroup().raiseException();
                    break;
                }
                errorCode = this.getErrorCode(e);
                if (errorCode == 3113 || errorCode == 17909 || errorCode == 17902 || errorCode == 17410) {
                    reConnect = true;
                    errorCode = 0;
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                reConnect = false;
            }
        }
        this.closeThisListener();
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "run", "connectionId={0}, userName={1}. end of run method. Thread will be closed. ", (String)null, (Throwable)null, (Object)this.jmsConnectionId, (Object)this.userName);
    }

    private int getErrorCode(Throwable e) {
        int errorCode = -1;
        int xLevelMax = 10;
        boolean done = false;
        do {
            if (e instanceof SQLException) {
                errorCode = ((SQLException)e).getErrorCode();
            } else if (e instanceof NetException) {
                errorCode = ((NetException)e).getErrorNumber();
            }
            if (errorCode == -1) {
                if (e.getCause() == null) {
                    done = true;
                    continue;
                }
                e = e.getCause();
                continue;
            }
            done = true;
        } while (!done && --xLevelMax > 0);
        return errorCode;
    }

    Connection getConnection(int noOfTries) throws SQLException, InterruptedException {
        Connection notificationConnection = null;
        OracleDataSource ods = new OracleDataSource();
        Properties props = new Properties();
        if (this.connectionProps != null) {
            props.putAll((Map<?, ?>)this.connectionProps);
        }
        if (this.userName != null) {
            ods.setUser(this.userName);
            ods.setPassword(this.password.get());
        }
        if (this.connClass != null) {
            props.put("oracle.jdbc.DRCPConnectionClass", this.connClass);
            props.put("oracle.jdbc.jmsNotification", "true");
            props.put("oracle.jdbc.ReadTimeout", (Object)0);
            props.put("oracle.net.CONNECT_TIMEOUT", (Object)0);
        }
        props.put("oracle.jdbc.enableACSupport", "false");
        ods.setConnectionProperties(props);
        while (notificationConnection == null && noOfTries++ < 5 && !this.needToBeClosed) {
            notificationConnection = this.tryListenerAddressesToGetConnection(ods);
            if (notificationConnection != null || noOfTries >= 5) continue;
            Thread.sleep(noOfTries * 1000);
        }
        if (notificationConnection == null && !this.needToBeClosed) {
            throw new SQLException("Failed to create notification connection to emon server");
        }
        return notificationConnection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Connection tryListenerAddressesToGetConnection(OracleDataSource ods) {
        Iterator<String> iterator = this.listenerAddresses.iterator();
        while (iterator.hasNext()) {
            String listenerAddress = iterator.next();
            String url = "jdbc:oracle:thin:@(DESCRIPTION=" + listenerAddress + "(CONNECT_DATA=(SERVICE_NAME=" + this.serviceName + ")(SERVER=EMON)(INSTANCE_NAME=" + this.instanceName + ")))";
            ods.setURL(url);
            try {
                Monitor.CloseableLock lock = this.acquireCloseableLock();
                try {
                    if (this.needToBeClosed) {
                        Connection connection = null;
                        return connection;
                    }
                    Connection notificationConnection = ods.getConnection();
                    if (notificationConnection == null) continue;
                    Connection connection = notificationConnection;
                    return connection;
                }
                finally {
                    if (lock == null) continue;
                    lock.close();
                }
            }
            catch (SQLException sqe) {
                this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "tryListenerAddressesToGetConnection", "JMSConnectionURL={0}, userName={1}. ", (String)null, sqe, (Object)url, (Object)this.userName);
            }
        }
        return null;
    }

    void closeThisListener() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.needToBeClosed = true;
            try {
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (SQLException ex) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "closeThisListener", "jmsConnectionId={0}, userName={1}. ", (String)null, ex, (Object)this.jmsConnectionId, (Object)this.userName);
            }
        }
    }

    void prepareForClose() {
        this.setNeedToBeClosed(true);
        this.stopListening();
        this.interrupt();
    }

    void stopListening() {
        if (this.oaqnfy != null) {
            this.oaqnfy.stopListening();
        }
    }

    void setNeedToBeClosed(boolean _needToBeClosed) {
        this.needToBeClosed = _needToBeClosed;
    }

    String getJMSConnectionId() {
        return this.jmsConnectionId;
    }

    int getNumberOfRegistrations() {
        return this.numberOfRegistrations;
    }

    void incrementNumberOfRegistrations(int n) {
        this.numberOfRegistrations += n;
    }

    void decrementNumberOfRegistrations(int n) {
        this.numberOfRegistrations -= n;
    }

    void setConnectionGroup(NTFJMSConnectionGroup _connGroup) {
        this.connectionGroup = _connGroup;
    }

    NTFJMSConnectionGroup getConnectionGroup() {
        if (this.connectionGroup == null) {
            this.connectionGroup = PhysicalConnection.ntfManager.getJMSConnectionGroup(this.userName + this.instanceName);
        }
        return this.connectionGroup;
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }
}

