/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.kubernetes;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.crypto.PublicKeysWrapper;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.keys.PublicKeyLoader;
import org.keycloak.models.KeycloakSession;
import org.keycloak.util.JWKSUtils;
import org.keycloak.util.JsonSerialization;

public class KubernetesJwksEndpointLoader
implements PublicKeyLoader {
    private final KeycloakSession session;
    private final boolean authenticate;
    private final String endpoint;

    public KubernetesJwksEndpointLoader(KeycloakSession session, String globalEndpoint, String providerEndpoint) {
        this.session = session;
        if (globalEndpoint == null && providerEndpoint == null) {
            throw new RuntimeException("Not running on Kubernetes and Kubernetes JWKS endpoint not set");
        }
        if (providerEndpoint == null || providerEndpoint.isEmpty() || globalEndpoint.equals(providerEndpoint)) {
            this.endpoint = globalEndpoint;
            this.authenticate = true;
        } else {
            this.endpoint = providerEndpoint;
            this.authenticate = false;
        }
    }

    public PublicKeysWrapper loadKeys() throws Exception {
        CloseableHttpClient httpClient = ((HttpClientProvider)this.session.getProvider(HttpClientProvider.class)).getHttpClient();
        HttpGet httpGet = new HttpGet(this.endpoint);
        httpGet.setHeader("Accept", "application/jwk-set+json");
        if (this.authenticate) {
            String token = FileUtils.readFileToString((File)new File("/var/run/secrets/kubernetes.io/serviceaccount/token"), (Charset)StandardCharsets.UTF_8);
            httpGet.setHeader("Authorization", "Bearer " + token);
        }
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
            JSONWebKeySet jwks = (JSONWebKeySet)JsonSerialization.readValue((InputStream)response.getEntity().getContent(), JSONWebKeySet.class);
            PublicKeysWrapper publicKeysWrapper = JWKSUtils.getKeyWrappersForUse((JSONWebKeySet)jwks, (JWK.Use)JWK.Use.SIG);
            return publicKeysWrapper;
        }
    }
}

