/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jwk;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.common.util.PemUtils;

public class JWK {
    public static final String KEY_ID = "kid";
    public static final String KEY_TYPE = "kty";
    public static final String ALGORITHM = "alg";
    public static final String PUBLIC_KEY_USE = "use";
    public static final String X5C = "x5c";
    public static final String SHA1_509_THUMBPRINT = "x5t";
    public static final String SHA256_509_THUMBPRINT = "x5t#S256";
    @JsonProperty(value="kid")
    private String keyId;
    @JsonProperty(value="kty")
    private String keyType;
    @JsonProperty(value="alg")
    private String algorithm;
    @JsonProperty(value="use")
    private String publicKeyUse;
    @JsonProperty(value="x5c")
    private String[] x509CertificateChain;
    @JsonProperty(value="x5t")
    private String sha1x509Thumbprint;
    @JsonProperty(value="x5t#S256")
    private String sha256x509Thumbprint;
    protected Map<String, Object> otherClaims = new HashMap<String, Object>();

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getPublicKeyUse() {
        return this.publicKeyUse;
    }

    public void setPublicKeyUse(String publicKeyUse) {
        this.publicKeyUse = publicKeyUse;
    }

    public String[] getX509CertificateChain() {
        return this.x509CertificateChain;
    }

    public void setX509CertificateChain(String[] x509CertificateChain) {
        this.x509CertificateChain = x509CertificateChain;
    }

    public String getSha1x509Thumbprint() {
        if (this.sha1x509Thumbprint == null && this.x509CertificateChain != null && this.x509CertificateChain.length > 0) {
            try {
                this.sha1x509Thumbprint = PemUtils.generateThumbprint((String[])this.x509CertificateChain, (String)"SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return this.sha1x509Thumbprint;
    }

    public void setSha1x509Thumbprint(String sha1x509Thumbprint) {
        this.sha1x509Thumbprint = sha1x509Thumbprint;
    }

    public String getSha256x509Thumbprint() {
        if (this.sha256x509Thumbprint == null && this.x509CertificateChain != null && this.x509CertificateChain.length > 0) {
            try {
                this.sha256x509Thumbprint = PemUtils.generateThumbprint((String[])this.x509CertificateChain, (String)"SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return this.sha256x509Thumbprint;
    }

    public void setSha256x509Thumbprint(String sha256x509Thumbprint) {
        this.sha256x509Thumbprint = sha256x509Thumbprint;
    }

    @JsonAnyGetter
    public Map<String, Object> getOtherClaims() {
        return this.otherClaims;
    }

    @JsonAnySetter
    public void setOtherClaims(String name, Object value) {
        this.otherClaims.put(name, value);
    }

    @JsonIgnore
    public <T> T getOtherClaim(String claimName, Class<T> claimType) {
        Object o = this.getOtherClaims().get(claimName);
        return o == null ? null : (T)claimType.cast(o);
    }

    @Deprecated
    public static enum Use {
        SIG("sig"),
        ENCRYPTION("enc"),
        JWT_SVID("jwt-svid");

        private String str;

        private Use(String str) {
            this.str = str;
        }

        public String asString() {
            return this.str;
        }
    }
}

