/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.internal;

public final class ArraySizeUtil {
    private static final int SOFT_MAX_ARRAY_LENGTH = 0x7FFFFFF7;
    private static final int MIN_ARRAY_LENGTH = 8;

    private ArraySizeUtil() {
    }

    public static int increaseArraySize(int currentSize, int requiredIndex) {
        int newSize;
        if (currentSize <= 4) {
            newSize = 8;
        } else if (currentSize <= 0x3FFFFFFB) {
            newSize = currentSize << 1;
        } else if (currentSize < 0x7FFFFFF7) {
            newSize = 0x7FFFFFF7;
        } else if (currentSize < Integer.MAX_VALUE) {
            newSize = currentSize + 1;
        } else {
            throw new OutOfMemoryError();
        }
        return Math.max(newSize, requiredIndex + 1);
    }
}

