/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.awt.Point;
import java.awt.Rectangle;
import java.lang.ref.WeakReference;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import org.GNOME.Accessibility.AtkUtil;

public class AtkComponent {
    WeakReference<AccessibleContext> _ac;
    WeakReference<AccessibleComponent> _acc_component;

    public AtkComponent(AccessibleContext accessibleContext) {
        this._ac = new WeakReference<AccessibleContext>(accessibleContext);
        this._acc_component = new WeakReference<AccessibleComponent>(accessibleContext.getAccessibleComponent());
    }

    public static AtkComponent createAtkComponent(AccessibleContext accessibleContext) {
        return AtkUtil.invokeInSwing(() -> new AtkComponent(accessibleContext), null);
    }

    public static Point getWindowLocation(AccessibleContext accessibleContext) {
        while (accessibleContext != null) {
            Object object;
            AccessibleRole accessibleRole = accessibleContext.getAccessibleRole();
            if (accessibleRole == AccessibleRole.DIALOG || accessibleRole == AccessibleRole.FRAME || accessibleRole == AccessibleRole.WINDOW) {
                object = accessibleContext.getAccessibleComponent();
                if (object == null) {
                    return null;
                }
                return object.getLocationOnScreen();
            }
            object = accessibleContext.getAccessibleParent();
            if (object == null) {
                return null;
            }
            accessibleContext = object.getAccessibleContext();
        }
        return null;
    }

    public static Point getComponentOrigin(AccessibleContext accessibleContext, AccessibleComponent accessibleComponent, int n) {
        if (n == 0) {
            return accessibleComponent.getLocationOnScreen();
        }
        if (n == 1) {
            Point point = AtkComponent.getWindowLocation(accessibleContext);
            if (point == null) {
                return null;
            }
            Point point2 = accessibleComponent.getLocationOnScreen();
            if (point2 == null) {
                return null;
            }
            point2.translate(-point.x, -point.y);
            return point2;
        }
        if (n == 2) {
            return accessibleComponent.getLocation();
        }
        return null;
    }

    public static Point getParentOrigin(AccessibleContext accessibleContext, AccessibleComponent accessibleComponent, int n) {
        if (n == 2) {
            return new Point(0, 0);
        }
        Accessible accessible = accessibleContext.getAccessibleParent();
        if (accessible == null) {
            return null;
        }
        AccessibleContext accessibleContext2 = accessible.getAccessibleContext();
        if (accessibleContext2 == null) {
            return null;
        }
        AccessibleComponent accessibleComponent2 = accessibleContext2.getAccessibleComponent();
        if (accessibleComponent2 == null) {
            return null;
        }
        if (n == 0) {
            return accessibleComponent2.getLocationOnScreen();
        }
        if (n == 1) {
            Point point = AtkComponent.getWindowLocation(accessibleContext);
            if (point == null) {
                return null;
            }
            Point point2 = accessibleComponent2.getLocationOnScreen();
            if (point2 == null) {
                return null;
            }
            point2.translate(-point.x, -point.y);
            return point2;
        }
        return null;
    }

    public boolean contains(int n, int n2, int n3) {
        AccessibleContext accessibleContext = (AccessibleContext)this._ac.get();
        if (accessibleContext == null) {
            return false;
        }
        AccessibleComponent accessibleComponent = (AccessibleComponent)this._acc_component.get();
        if (accessibleComponent == null) {
            return false;
        }
        return AtkUtil.invokeInSwing(() -> {
            if (accessibleComponent.isVisible()) {
                Point point = AtkComponent.getComponentOrigin(accessibleContext, accessibleComponent, n3);
                if (point == null) {
                    return false;
                }
                return accessibleComponent.contains(new Point(n - point.x, n2 - point.y));
            }
            return false;
        }, false);
    }

    public AccessibleContext get_accessible_at_point(int n, int n2, int n3) {
        AccessibleContext accessibleContext = (AccessibleContext)this._ac.get();
        if (accessibleContext == null) {
            return null;
        }
        AccessibleComponent accessibleComponent = (AccessibleComponent)this._acc_component.get();
        if (accessibleComponent == null) {
            return null;
        }
        return AtkUtil.invokeInSwing(() -> {
            if (accessibleComponent.isVisible()) {
                Point point = AtkComponent.getComponentOrigin(accessibleContext, accessibleComponent, n3);
                if (point == null) {
                    return null;
                }
                Accessible accessible = accessibleComponent.getAccessibleAt(new Point(n - point.x, n2 - point.y));
                if (accessible == null) {
                    return null;
                }
                return accessible.getAccessibleContext();
            }
            return null;
        }, null);
    }

    public boolean grab_focus() {
        AccessibleComponent accessibleComponent = (AccessibleComponent)this._acc_component.get();
        if (accessibleComponent == null) {
            return false;
        }
        return AtkUtil.invokeInSwing(() -> {
            if (!accessibleComponent.isFocusTraversable()) {
                return false;
            }
            accessibleComponent.requestFocus();
            return true;
        }, false);
    }

    public boolean set_extents(int n, int n2, int n3, int n4, int n5) {
        AccessibleContext accessibleContext = (AccessibleContext)this._ac.get();
        if (accessibleContext == null) {
            return false;
        }
        AccessibleComponent accessibleComponent = (AccessibleComponent)this._acc_component.get();
        if (accessibleComponent == null) {
            return false;
        }
        return AtkUtil.invokeInSwing(() -> {
            if (accessibleComponent.isVisible()) {
                Point point = AtkComponent.getParentOrigin(accessibleContext, accessibleComponent, n5);
                if (point == null) {
                    return false;
                }
                accessibleComponent.setBounds(new Rectangle(n - point.x, n2 - point.y, n3, n4));
                return true;
            }
            return false;
        }, false);
    }

    public Rectangle get_extents(int n) {
        AccessibleContext accessibleContext = (AccessibleContext)this._ac.get();
        if (accessibleContext == null) {
            return null;
        }
        AccessibleComponent accessibleComponent = (AccessibleComponent)this._acc_component.get();
        if (accessibleComponent == null) {
            return null;
        }
        return AtkUtil.invokeInSwing(() -> {
            if (accessibleComponent.isVisible()) {
                Rectangle rectangle = accessibleComponent.getBounds();
                if (rectangle == null) {
                    return null;
                }
                Point point = AtkComponent.getParentOrigin(accessibleContext, accessibleComponent, n);
                if (point == null) {
                    return null;
                }
                rectangle.x += point.x;
                rectangle.y += point.y;
                return rectangle;
            }
            return null;
        }, null);
    }

    public int get_layer() {
        AccessibleContext accessibleContext = (AccessibleContext)this._ac.get();
        if (accessibleContext == null) {
            return 0;
        }
        return AtkUtil.invokeInSwing(() -> {
            AccessibleRole accessibleRole = accessibleContext.getAccessibleRole();
            if (accessibleRole == AccessibleRole.MENU || accessibleRole == AccessibleRole.MENU_ITEM || accessibleRole == AccessibleRole.POPUP_MENU) {
                return 5;
            }
            if (accessibleRole == AccessibleRole.INTERNAL_FRAME) {
                return 4;
            }
            if (accessibleRole == AccessibleRole.GLASS_PANE) {
                return 6;
            }
            if (accessibleRole == AccessibleRole.CANVAS || accessibleRole == AccessibleRole.ROOT_PANE || accessibleRole == AccessibleRole.LAYERED_PANE) {
                return 2;
            }
            if (accessibleRole == AccessibleRole.WINDOW) {
                return 7;
            }
            return 3;
        }, 0);
    }
}

