/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.analysis;

import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitDataFlowBlockAnalyzer;
import ghidra.pcode.emu.jit.analysis.JitDataFlowModel;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.MathUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SequencedSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class JitVarScopeModel {
    private final JitControlFlowModel cfm;
    private final JitDataFlowModel dfm;
    private final NavigableMap<Address, Varnode> coalesced = new TreeMap<Address, Varnode>();
    private final Map<JitControlFlowModel.JitBlock, ScopeInfo> infos = new HashMap<JitControlFlowModel.JitBlock, ScopeInfo>();
    private final SequencedSet<ScopeInfo> blockQueue = new LinkedHashSet<ScopeInfo>();

    public JitVarScopeModel(JitControlFlowModel cfm, JitDataFlowModel dfm) {
        this.cfm = cfm;
        this.dfm = dfm;
        this.analyze();
    }

    static Address maxAddr(Varnode varnode) {
        return varnode.getAddress().add((long)(varnode.getSize() - 1));
    }

    static boolean overlapsLeft(Varnode left, Varnode right) {
        return JitVarScopeModel.maxAddr(left).compareTo((Object)right.getAddress()) >= 0;
    }

    private void coalesceVarnode(Varnode varnode) {
        Varnode existsRight;
        Map.Entry<Address, Varnode> rightEntry;
        Address min = varnode.getAddress();
        Address max = JitVarScopeModel.maxAddr(varnode);
        Map.Entry<Address, Varnode> leftEntry = this.coalesced.floorEntry(min);
        if (leftEntry != null && JitVarScopeModel.overlapsLeft(leftEntry.getValue(), varnode)) {
            min = leftEntry.getKey();
        }
        if ((rightEntry = this.coalesced.floorEntry(max)) != null) {
            max = (Address)MathUtilities.cmax((Comparable)max, (Comparable)JitVarScopeModel.maxAddr(rightEntry.getValue()));
        }
        Varnode exists = leftEntry == null ? null : leftEntry.getValue();
        Varnode varnode2 = existsRight = rightEntry == null ? null : rightEntry.getValue();
        if (exists == existsRight && exists != null && exists.getAddress().equals((Object)min) && JitVarScopeModel.maxAddr(exists).equals((Object)max)) {
            return;
        }
        this.coalesced.subMap(min, true, JitVarScopeModel.maxAddr(varnode), true).clear();
        this.coalesced.put(min, new Varnode(min, (int)max.subtract(min) + 1));
    }

    private void coalesceVarnodes() {
        HashSet<Varnode> allVarnodes = new HashSet<Varnode>();
        for (JitControlFlowModel.JitBlock block : this.cfm.getBlocks()) {
            allVarnodes.addAll(this.dfm.getAnalyzer(block).getVarnodesRead());
            allVarnodes.addAll(this.dfm.getAnalyzer(block).getVarnodesWritten());
        }
        for (Varnode varnode : allVarnodes) {
            if (varnode.isAddress()) continue;
            this.coalesceVarnode(varnode);
        }
    }

    public Varnode getCoalesced(Varnode part) {
        if (part.isAddress()) {
            return part;
        }
        Map.Entry<Address, Varnode> floorEntry = this.coalesced.floorEntry(part.getAddress());
        assert (JitVarScopeModel.overlapsLeft(floorEntry.getValue(), part));
        return floorEntry.getValue();
    }

    private boolean pushNext(Which which) {
        if (this.blockQueue.isEmpty()) {
            return false;
        }
        ScopeInfo info = (ScopeInfo)this.blockQueue.removeFirst();
        info.push(which);
        return !this.blockQueue.isEmpty();
    }

    private void analyze() {
        this.coalesceVarnodes();
        for (JitControlFlowModel.JitBlock block : this.cfm.getBlocks()) {
            ScopeInfo info = new ScopeInfo(block);
            this.infos.put(block, info);
            this.blockQueue.add(info);
        }
        while (this.pushNext(Which.UP)) {
        }
        this.blockQueue.addAll(this.infos.values());
        while (this.pushNext(Which.DOWN)) {
        }
        for (ScopeInfo info : this.infos.values()) {
            info.finish();
        }
    }

    public Iterable<Varnode> coalescedVarnodes() {
        return this.coalesced.values();
    }

    public Set<Varnode> getLiveVars(JitControlFlowModel.JitBlock block) {
        return this.infos.get((Object)block).liveVarsImm;
    }

    public void dumpResult() {
        System.err.println("STAGE: VarLiveness");
        for (JitControlFlowModel.JitBlock block : this.cfm.getBlocks()) {
            System.err.println("  Block: " + String.valueOf(block));
            TreeSet<String> liveNames = new TreeSet<String>();
            for (Varnode vn : this.infos.get((Object)block).liveVarsImm) {
                Register register = block.getLanguage().getRegister(vn.getAddress(), vn.getSize());
                if (register != null) {
                    liveNames.add(register.getName());
                    continue;
                }
                if (vn.isUnique()) {
                    liveNames.add("$U%x:%d".formatted(vn.getOffset(), vn.getSize()));
                    continue;
                }
                liveNames.add("%s:%x:4".formatted(vn.getAddress().getAddressSpace().getName(), vn.getOffset(), vn.getSize()));
            }
            System.err.println("    Live: " + String.valueOf(liveNames));
        }
    }

    private class ScopeInfo {
        private final JitControlFlowModel.JitBlock block;
        private final Set<Varnode> liveUp = new HashSet<Varnode>();
        private final Set<Varnode> liveDn = new HashSet<Varnode>();
        private final Set<Varnode> queuedUp = new HashSet<Varnode>();
        private final Set<Varnode> queuedDn = new HashSet<Varnode>();
        private final Set<Varnode> liveVars = new LinkedHashSet<Varnode>();
        private final Set<Varnode> liveVarsImm = Collections.unmodifiableSet(this.liveVars);

        public ScopeInfo(JitControlFlowModel.JitBlock block) {
            this.block = block;
            JitDataFlowBlockAnalyzer dfa = JitVarScopeModel.this.dfm.getAnalyzer(block);
            for (Varnode vn : dfa.getVarnodesRead()) {
                if (vn.isAddress()) continue;
                this.queuedUp.add(JitVarScopeModel.this.getCoalesced(vn));
                this.queuedDn.add(JitVarScopeModel.this.getCoalesced(vn));
            }
            for (Varnode vn : dfa.getVarnodesWritten()) {
                if (vn.isAddress()) continue;
                this.queuedUp.add(JitVarScopeModel.this.getCoalesced(vn));
                this.queuedDn.add(JitVarScopeModel.this.getCoalesced(vn));
            }
        }

        private void push(Which which) {
            Set<Varnode> queued = which.getQueued(this);
            if (queued.isEmpty()) {
                return;
            }
            for (JitControlFlowModel.JitBlock block : which.getFlows(this)) {
                ScopeInfo that = JitVarScopeModel.this.infos.get(block);
                HashSet<Varnode> toQueueThat = new HashSet<Varnode>(queued);
                toQueueThat.removeAll(which.getLive(that));
                if (!which.getQueued(that).addAll(toQueueThat)) continue;
                JitVarScopeModel.this.blockQueue.add(that);
            }
            which.getLive(this).addAll(queued);
            queued.clear();
        }

        private void finish() {
            ArrayList<Varnode> sortedLiveUp = new ArrayList<Varnode>(this.liveUp);
            Collections.sort(sortedLiveUp, Comparator.comparing(Varnode::getAddress));
            this.liveVars.addAll(sortedLiveUp);
            this.liveVars.retainAll(this.liveDn);
        }
    }

    static enum Which {
        UP{

            @Override
            Collection<JitControlFlowModel.JitBlock> getFlows(ScopeInfo info) {
                return info.block.flowsTo().values().stream().map(JitControlFlowModel.BlockFlow::from).toList();
            }

            @Override
            Set<Varnode> getLive(ScopeInfo info) {
                return info.liveUp;
            }

            @Override
            Set<Varnode> getQueued(ScopeInfo info) {
                return info.queuedUp;
            }
        }
        ,
        DOWN{

            @Override
            Collection<JitControlFlowModel.JitBlock> getFlows(ScopeInfo info) {
                return info.block.flowsFrom().values().stream().map(JitControlFlowModel.BlockFlow::to).toList();
            }

            @Override
            Set<Varnode> getLive(ScopeInfo info) {
                return info.liveDn;
            }

            @Override
            Set<Varnode> getQueued(ScopeInfo info) {
                return info.queuedDn;
            }
        };


        abstract Collection<JitControlFlowModel.JitBlock> getFlows(ScopeInfo var1);

        abstract Set<Varnode> getLive(ScopeInfo var1);

        abstract Set<Varnode> getQueued(ScopeInfo var1);
    }
}

