/*
 * Decompiled with CFR 0.152.
 */
package generic.theme;

import generic.theme.GColor;
import generic.theme.GThemeValueMap;
import generic.theme.ThemeManager;
import generic.theme.ThemeValue;
import ghidra.util.Msg;
import ghidra.util.WebColors;
import java.awt.Color;
import org.apache.commons.lang3.StringUtils;
import utilities.util.reflection.ReflectionUtilities;

public class ColorValue
extends ThemeValue<Color> {
    public static final String LAF_ID_PREFIX = "laf.color.";
    public static final String EXTERNAL_LAF_ID_PREFIX = "[laf.color]";
    private static final String COLOR_ID_PREFIX = "color.";
    private static final String EXTERNAL_PREFIX = "[color]";
    public static final Color LAST_RESORT_DEFAULT = new Color(128, 128, 128);

    public ColorValue(String id, Color value) {
        super(id, ColorValue.getRefId(value), ColorValue.getRawColor(value));
    }

    public ColorValue(String id, String refId) {
        super(id, refId, null);
    }

    @Override
    public String getSerializationString() {
        String outputId = ColorValue.toExternalId(this.id);
        return outputId + " = " + this.getSerializedValue();
    }

    @Override
    public boolean isExternal() {
        return !this.id.startsWith(COLOR_ID_PREFIX);
    }

    public static boolean isColorKey(String key) {
        return StringUtils.startsWithAny((CharSequence)key, (CharSequence[])new CharSequence[]{COLOR_ID_PREFIX, EXTERNAL_PREFIX, EXTERNAL_LAF_ID_PREFIX});
    }

    public static ColorValue parse(String key, String value) {
        String id = ColorValue.fromExternalId(key);
        if (ColorValue.isColorKey(value)) {
            return new ColorValue(id, ColorValue.fromExternalId(value));
        }
        Color color = WebColors.getColor(value);
        return color == null ? null : new ColorValue(id, color);
    }

    protected ColorValue getReferredValue(GThemeValueMap values, String refId) {
        return values.getColor(refId);
    }

    @Override
    protected Color getUnresolvedReferenceValue(String primaryId, String unresolvedId) {
        Throwable t = ReflectionUtilities.createThrowableWithStackOlderThan((Class[])new Class[]{this.getClass()});
        StackTraceElement[] trace = t.getStackTrace();
        StackTraceElement[] filtered = ReflectionUtilities.filterStackTrace((StackTraceElement[])trace, (String[])new String[]{"docking.theme", "classfinder", "Application", "ghidra.GhidraRun", "java.lang.Class", "java.lang.Thread"});
        t.setStackTrace(filtered);
        Msg.error((Object)this, (Object)("Could not resolve indirect color path for \"" + unresolvedId + "\" for primary id \"" + primaryId + "\", using last resort default"), (Throwable)t);
        return LAST_RESORT_DEFAULT;
    }

    private static String toExternalId(String internalId) {
        if (internalId.startsWith(COLOR_ID_PREFIX)) {
            return internalId;
        }
        if (internalId.startsWith(LAF_ID_PREFIX)) {
            String baseId = internalId.substring(LAF_ID_PREFIX.length());
            return EXTERNAL_LAF_ID_PREFIX + baseId;
        }
        return EXTERNAL_PREFIX + internalId;
    }

    private static String fromExternalId(String externalId) {
        if (externalId.startsWith(EXTERNAL_PREFIX)) {
            return externalId.substring(EXTERNAL_PREFIX.length());
        }
        if (externalId.startsWith(EXTERNAL_LAF_ID_PREFIX)) {
            return LAF_ID_PREFIX + externalId.substring(EXTERNAL_LAF_ID_PREFIX.length());
        }
        return externalId;
    }

    private static Color getRawColor(Color value) {
        if (value instanceof GColor) {
            return null;
        }
        return value;
    }

    private static String getRefId(Color value) {
        if (value instanceof GColor) {
            return ((GColor)value).getId();
        }
        return null;
    }

    private String getSerializedValue() {
        if (this.referenceId != null) {
            return ColorValue.toExternalId(this.referenceId);
        }
        Object outputString = WebColors.toString((Color)this.value, false);
        String colorName = WebColors.toWebColorName((Color)this.value);
        if (colorName != null) {
            outputString = (String)outputString + " // " + colorName;
        }
        return outputString;
    }

    @Override
    public void installValue(ThemeManager themeManager) {
        themeManager.setColor(this);
    }
}

