/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.IntListIndexer;
import ghidra.util.datastruct.Prime;
import ghidra.util.exception.AssertException;
import java.io.Serializable;

public class LongKeyIndexer
implements Serializable {
    private static final int DEFAULT_CAPACITY = 13;
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private long[] keys;
    private IntListIndexer indexer;
    private int capacity;

    public LongKeyIndexer() {
        this(13);
    }

    public LongKeyIndexer(int capacity) {
        this.capacity = capacity = Prime.nextPrime(capacity);
        this.indexer = new IntListIndexer(capacity, capacity);
        this.keys = new long[capacity];
    }

    public int put(long key) {
        int index = this.findKey(key);
        if (index == -1) {
            int hashcode;
            if (this.indexer.getSize() >= this.capacity) {
                this.grow();
            }
            if ((index = this.indexer.add(hashcode = ((int)key & Integer.MAX_VALUE) % this.capacity)) < 0) {
                throw new IndexOutOfBoundsException("Maximum capacity reached");
            }
            this.keys[index] = key;
        }
        return index;
    }

    public int get(long key) {
        return this.findKey(key);
    }

    public int remove(long key) {
        int index = this.findKey(key);
        if (index == -1) {
            return -1;
        }
        int hashcode = ((int)key & Integer.MAX_VALUE) % this.capacity;
        this.indexer.remove(hashcode, index);
        return index;
    }

    public int getSize() {
        return this.indexer.getSize();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void clear() {
        this.indexer.clear();
    }

    public long[] getKeys() {
        int size = this.getSize();
        if (size == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] keyArray = new long[size];
        int pos = 0;
        int nLists = this.indexer.getNumLists();
        for (int i = 0; i < nLists; ++i) {
            int keyIndex = this.indexer.first(i);
            while (keyIndex >= 0) {
                keyArray[pos++] = this.keys[keyIndex];
                keyIndex = this.indexer.next(keyIndex);
            }
        }
        if (pos != this.getSize()) {
            throw new AssertException("Trouble in IntKeyIndexer.getKeys(), size = " + this.getSize() + "  pos= " + pos);
        }
        return keyArray;
    }

    private int findKey(long key) {
        int hashcode = ((int)key & Integer.MAX_VALUE) % this.capacity;
        int p = this.indexer.first(hashcode);
        while (p != -1) {
            if (this.keys[p] == key) {
                return p;
            }
            p = this.indexer.next(p);
        }
        return -1;
    }

    private void grow() {
        int newCapacity = Prime.nextPrime(this.indexer.getNewCapacity());
        this.indexer.growCapacity(newCapacity);
        this.indexer.growNumLists(newCapacity);
        this.indexer.clear();
        long[] oldKeys = this.keys;
        this.keys = new long[newCapacity];
        this.capacity = newCapacity;
        for (long oldKey : oldKeys) {
            this.put(oldKey);
        }
    }
}

