/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.codecompare.model;

import ghidra.features.base.codecompare.model.FunctionComparisonModel;
import ghidra.features.base.codecompare.model.FunctionComparisonModelListener;
import ghidra.program.model.listing.Function;
import ghidra.util.datastruct.Duo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public abstract class AbstractFunctionComparisonModel
implements FunctionComparisonModel {
    public static Comparator<Function> FUNCTION_COMPARATOR = new FunctionComparator();
    private List<FunctionComparisonModelListener> listeners = new ArrayList<FunctionComparisonModelListener>();
    protected Duo<Function> activeFunctions = new Duo();

    @Override
    public void addFunctionComparisonModelListener(FunctionComparisonModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeFunctionComparisonModelListener(FunctionComparisonModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean setActiveFunction(Duo.Side side, Function function) {
        if (this.activeFunctions.get(side) == function) {
            return false;
        }
        if (!this.containsFunction(side, function)) {
            return false;
        }
        this.activeFunctions = this.activeFunctions.with(side, (Object)function);
        this.fireActiveFunctionChanged(side, function);
        return true;
    }

    @Override
    public Function getActiveFunction(Duo.Side side) {
        return (Function)this.activeFunctions.get(side);
    }

    private void fireActiveFunctionChanged(Duo.Side side, Function function) {
        this.listeners.forEach(l -> l.activeFunctionChanged(side, function));
    }

    protected void fireModelDataChanged() {
        this.listeners.forEach(l -> l.modelDataChanged());
    }

    protected abstract boolean containsFunction(Duo.Side var1, Function var2);

    private static class FunctionComparator
    implements Comparator<Function> {
        private FunctionComparator() {
        }

        @Override
        public int compare(Function o1, Function o2) {
            String o1Path = o1.getProgram().getDomainFile().getPathname();
            String o2Path = o2.getProgram().getDomainFile().getPathname();
            String o1Name = o1.getName();
            String o2Name = o2.getName();
            if (o1Path.equals(o2Path)) {
                if (o1Name.equals(o2Name)) {
                    return o1.getEntryPoint().compareTo((Object)o2.getEntryPoint());
                }
                return o1Name.compareTo(o2Name);
            }
            return o1Path.compareTo(o2Path);
        }
    }
}

