/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.AbstractOffsetFieldFactory;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.util.OffsetFieldType;

public class ImagebaseOffsetFieldFactory
extends AbstractOffsetFieldFactory {
    private static final String FIELD_OFFSET_DESCRIPTION = "Imagebase";
    private static final String FIELD_NAME_DESCRIPTION = "Field";

    public ImagebaseOffsetFieldFactory() {
        super(FIELD_OFFSET_DESCRIPTION);
    }

    private ImagebaseOffsetFieldFactory(FieldFormatModel model, ListingHighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_OFFSET_DESCRIPTION, FIELD_NAME_DESCRIPTION, model, hlProvider, displayOptions, fieldOptions);
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, ListingHighlightProvider highlightProvider, ToolOptions options, ToolOptions fieldOptions) {
        return new ImagebaseOffsetFieldFactory(formatModel, highlightProvider, (Options)options, (Options)fieldOptions);
    }

    @Override
    public String getOffsetValue(CodeUnit cu) {
        Address addr = cu.getAddress();
        Address imagebase = cu.getProgram().getImageBase();
        String text = "";
        if (addr.hasSameAddressSpace(imagebase)) {
            long imagebaseOffset = addr.subtract(cu.getProgram().getImageBase());
            text = String.format(this.useHex ? "0x%x" : "%d", imagebaseOffset);
            if (this.showName) {
                text = "imagebase:%s".formatted(text);
            }
        }
        return text;
    }

    @Override
    public OffsetFieldType getOffsetFieldType() {
        return OffsetFieldType.IMAGEBASE;
    }
}

