/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.opinion.IntelHexRecord;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.SegmentedAddress;
import ghidra.program.model.address.SegmentedAddressSpace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IntelHexRecordWriter {
    private final int maxBytesPerLine;
    private final boolean dropExtraBytes;
    private Address startAddress = null;
    private Long oldSegment = null;
    private ArrayList<Byte> bytes = new ArrayList();
    private Boolean isSegmented = null;
    private ArrayList<IntelHexRecord> results = new ArrayList();
    private boolean done = false;

    public IntelHexRecordWriter(int maxBytesPerLine, boolean dropExtraBytes) {
        if (maxBytesPerLine > 255) {
            throw new IllegalArgumentException("maxBytesPerLine > IntelHexRecord.MAX_RECORD_LENGTH");
        }
        this.maxBytesPerLine = maxBytesPerLine;
        this.dropExtraBytes = dropExtraBytes;
    }

    public void addByte(Address address, byte b) {
        long newSegment;
        long offset;
        if (this.done) {
            throw new IllegalStateException("cannot addByte() after finish()");
        }
        if (this.isSegmented == null) {
            this.isSegmented = address.getAddressSpace() instanceof SegmentedAddressSpace ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if (this.isSegmented.booleanValue()) {
            offset = ((SegmentedAddress)address).getSegmentOffset();
            newSegment = ((SegmentedAddress)address).getSegment();
        } else {
            offset = address.getOffset();
            newSegment = offset & 0xFFFFFFFFFFFF0000L;
        }
        boolean changeSegment = false;
        if (this.oldSegment == null) {
            changeSegment = true;
        } else if (newSegment != this.oldSegment) {
            changeSegment = true;
        }
        if (changeSegment) {
            this.emitData();
            byte[] data = new byte[2];
            if (this.isSegmented.booleanValue()) {
                SegmentedAddress saddress = (SegmentedAddress)address;
                int segment = saddress.getSegment();
                data[0] = (byte)(segment >> 8 & 0xFF);
                data[1] = (byte)(segment & 0xFF);
                this.results.add(new IntelHexRecord(2, 0, 2, data));
            } else {
                data[0] = (byte)(offset >> 24 & 0xFFL);
                data[1] = (byte)(offset >> 16 & 0xFFL);
                this.results.add(new IntelHexRecord(2, 0, 4, data));
            }
            this.oldSegment = newSegment;
        }
        if (this.startAddress == null) {
            this.startAddress = address;
        }
        this.bytes.add(b);
        if (this.bytes.size() >= this.maxBytesPerLine) {
            this.emitData();
        }
    }

    private void emitData() {
        int length = this.bytes.size();
        if (length > 0) {
            int loadOffset = this.isSegmented != false ? ((SegmentedAddress)this.startAddress).getSegmentOffset() : (int)(this.startAddress.getOffset() & 0xFFFFL);
            byte[] data = new byte[length];
            for (int ii = 0; ii < length; ++ii) {
                data[ii] = this.bytes.get(ii);
            }
            this.results.add(new IntelHexRecord(length, loadOffset, 0, data));
            this.bytes.clear();
            this.startAddress = null;
        }
    }

    public List<IntelHexRecord> finish(Address entryPoint) {
        if (this.bytes.size() > 0 && !this.dropExtraBytes) {
            this.emitData();
        }
        if (entryPoint != null && this.isSegmented != null) {
            long offset = entryPoint.getOffset();
            byte[] data = new byte[4];
            data[2] = (byte)(offset >> 8 & 0xFFL);
            data[3] = (byte)(offset & 0xFFL);
            if (this.isSegmented.booleanValue()) {
                SegmentedAddress saddress = (SegmentedAddress)entryPoint;
                int segment = saddress.getSegment();
                data[0] = (byte)(segment >> 8 & 0xFF);
                data[1] = (byte)(segment & 0xFF);
                this.results.add(new IntelHexRecord(4, 0, 3, data));
            } else {
                data[0] = (byte)(offset >> 24 & 0xFFL);
                data[1] = (byte)(offset >> 16 & 0xFFL);
                this.results.add(new IntelHexRecord(4, 0, 5, data));
            }
        }
        this.results.add(new IntelHexRecord(0, 0, 1, new byte[0]));
        this.done = true;
        return Collections.unmodifiableList(this.results);
    }
}

