/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.pe.ImageRuntimeFunctionEntries;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ImageRuntimeFunctionEntries_ARM
implements ImageRuntimeFunctionEntries {
    private static final int ENTRY_SIZE = 8;
    private List<ImageRuntimeFunctionEntry_ARM> functionEntries = new ArrayList<ImageRuntimeFunctionEntry_ARM>();

    ImageRuntimeFunctionEntries_ARM(BinaryReader reader, int size, NTHeader ntHeader) throws IOException {
        int numEntries = size / 8;
        for (int i = 0; i < numEntries; ++i) {
            long beginAddress = reader.readNextUnsignedInt() & 0xFFFFFFFFFFFFFFFEL;
            int data = reader.readNextInt();
            if (beginAddress == 0L && data == 0) break;
            this.functionEntries.add(new ImageRuntimeFunctionEntry_ARM(beginAddress, data));
        }
    }

    @Override
    public void markup(Program program, Address headerStart) throws CodeUnitInsertionException, IOException, DuplicateNameException {
        StructureDataType exceptionInfoStruct = new StructureDataType("_IMAGE_RUNTIME_FUNCTION_ENTRY", 0);
        exceptionInfoStruct.setPackingEnabled(true);
        exceptionInfoStruct.add(StructConverter.IBO32, "BeginAddress", null);
        exceptionInfoStruct.add(StructConverter.IBO32, "ExceptionInfo", null);
        StructureDataType unwindDataStruct = new StructureDataType("_IMAGE_RUNTIME_FUNCTION_ENTRY_2", 0);
        unwindDataStruct.setPackingEnabled(true);
        unwindDataStruct.add(StructConverter.IBO32, "BeginAddress", null);
        try {
            unwindDataStruct.addBitField(StructConverter.DWORD, 2, "Flag", null);
            unwindDataStruct.addBitField(StructConverter.DWORD, 11, "FunctionLength", null);
            unwindDataStruct.addBitField(StructConverter.DWORD, 2, "Ret", null);
            unwindDataStruct.addBitField(StructConverter.DWORD, 1, "H", null);
            unwindDataStruct.addBitField(StructConverter.DWORD, 3, "Reg", null);
            unwindDataStruct.addBitField(StructConverter.DWORD, 1, "R", null);
            unwindDataStruct.addBitField(StructConverter.DWORD, 1, "L", null);
            unwindDataStruct.addBitField(StructConverter.DWORD, 1, "C", null);
            unwindDataStruct.addBitField(StructConverter.DWORD, 10, "StackAdjust", null);
        }
        catch (InvalidDataTypeException e) {
            throw new IOException(e);
        }
        Address addr = headerStart;
        for (ImageRuntimeFunctionEntry_ARM entry : this.functionEntries) {
            StructureDataType struct = entry.isExceptionInfoRVA() ? exceptionInfoStruct : unwindDataStruct;
            DataUtilities.createData((Program)program, (Address)addr, (DataType)struct, (int)struct.getLength(), (boolean)true, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            addr = addr.add(8L);
        }
    }

    record ImageRuntimeFunctionEntry_ARM(long beginAddress, int data) {
        public boolean isExceptionInfoRVA() {
            return (this.data & 3) == 0;
        }

        public void markup(Program program) throws DuplicateNameException, IOException, CodeUnitInsertionException {
            if (this.isExceptionInfoRVA()) {
                // empty if block
            }
        }
    }
}

