/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.label;

import docking.DialogComponentProvider;
import ghidra.app.plugin.core.label.LabelHistoryTask;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.task.Task;
import ghidra.util.task.TaskListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LabelHistoryInputDialog
extends DialogComponentProvider {
    private JTextField inputField;
    private LabelHistoryTask task;
    private final Program program;
    private PluginTool tool;

    public LabelHistoryInputDialog(PluginTool tool, Program program) {
        super("Label History Search", true);
        this.program = program;
        this.tool = tool;
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addCancelButton();
        this.setHelpLocation(new HelpLocation("LabelMgrPlugin", "Show_All_History"));
    }

    protected void cancelCallback() {
        this.close();
    }

    protected void okCallback() {
        String text = this.inputField.getText();
        if (text.length() == 0) {
            text = null;
        }
        this.task = new LabelHistoryTask(this.tool, this.program, text);
        this.task.addTaskListener((TaskListener)this);
        this.tool.execute((Task)this.task, 250);
    }

    void showDialog() {
        this.clearStatusText();
        this.inputField.selectAll();
        this.tool.showDialog((DialogComponentProvider)this);
    }

    private JPanel buildMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Enter Symbol Name"));
        this.inputField = new JTextField(25);
        this.inputField.getAccessibleContext().setAccessibleName("Input");
        this.setFocusComponent(this.inputField);
        this.inputField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelHistoryInputDialog.this.okCallback();
            }
        });
        this.inputField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                LabelHistoryInputDialog.this.clearStatusText();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                LabelHistoryInputDialog.this.clearStatusText();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LabelHistoryInputDialog.this.clearStatusText();
            }
        });
        panel.add((Component)this.inputField, "Center");
        panel.getAccessibleContext().setAccessibleName("Name Entry");
        JPanel outerPanel = new JPanel(new BorderLayout());
        outerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        outerPanel.add((Component)panel, "Center");
        outerPanel.getAccessibleContext().setAccessibleName("Label History Input");
        return outerPanel;
    }

    public void taskCancelled(Task cancelTask) {
        this.taskCompleted(cancelTask);
    }

    public void taskCompleted(Task t) {
        if (!this.task.labelsFound()) {
            String matchStr = this.inputField.getText();
            if (matchStr.length() == 0) {
                this.setStatusText("No label history was found");
            } else {
                this.setStatusText("No matches were found for " + matchStr);
            }
        } else {
            this.close();
        }
    }
}

