/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.tray.ahessian.client;

import com.caucho.hessian4.io.SerializerFactory;
import io.netty.channel.Channel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.util.internal.logging.InternalLogger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerDelegateMBean;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.rzo.netty.ahessian.application.jmx.remote.service.JmxSerializerFactory;
import org.rzo.netty.ahessian.bootstrap.ChannelPipelineFactoryBuilder;
import org.rzo.netty.ahessian.bootstrap.ChannelPipelineFactoryFactory;
import org.rzo.netty.ahessian.bootstrap.DefaultClient;
import org.rzo.netty.ahessian.rpc.server.HessianRPCServiceHandler;
import org.rzo.netty.ahessian.utils.MyReentrantLock;
import org.rzo.netty.mcast.discovery.DiscoveryClient;
import org.rzo.netty.mcast.discovery.DiscoveryListener;

public class AHessianJmxClient {
    boolean stop = false;
    DiscoveryClient discovery = null;
    ExecutorService executor = Executors.newCachedThreadPool();
    volatile MBeanServerConnection mbeanServer = null;
    final Lock lock = new MyReentrantLock();
    final Condition connected = this.lock.newCondition();
    String currentHost = null;
    DefaultClient<MBeanServerConnection> client;
    Runnable _connectListener;
    Runnable _disconnectListener;
    String _discoveryName;
    int _port;
    boolean _debug = false;
    InternalLogger _logger;

    public AHessianJmxClient(String discoveryName, int port, boolean debug, InternalLogger logger) throws Exception {
        this._discoveryName = discoveryName;
        this._port = port;
        this._debug = debug;
        this._logger = logger;
        HashMap<String, Comparable<Boolean>> options = new HashMap<String, Comparable<Boolean>>();
        options.put("sync", Boolean.valueOf(true));
        options.put("timeout", Long.valueOf(5000L));
        ChannelPipelineFactoryBuilder builder = new ChannelPipelineFactoryBuilder().serviceThreads(10).reconnect(10L).rpcServiceInterface(MBeanServerConnection.class).serviceOptions(options);
        builder.debug();
        builder.serializerFactory((SerializerFactory)new JmxSerializerFactory());
        HashSet<String> channelOptions = new HashSet<String>();
        channelOptions.add("SO_REUSE");
        channelOptions.add("TCP_NODELAY");
        this.client = new DefaultClient(OioSocketChannel.class, (ChannelPipelineFactoryFactory)builder, channelOptions);
    }

    private void doConnected() {
        this.lock.lock();
        try {
            this.mbeanServer = (MBeanServerConnection)this.client.proxy();
            this.connected.signal();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lock.unlock();
        if (this._connectListener != null) {
            this._connectListener.run();
        }
    }

    public void start() throws Exception {
        this.client.disconnectedListener(new HessianRPCServiceHandler.ConnectListener(){

            public void run() {
                try {
                    System.out.println("disconnected listener");
                    AHessianJmxClient.this.close();
                    AHessianJmxClient.this.mbeanServer = null;
                    if (AHessianJmxClient.this.discovery != null) {
                        if (AHessianJmxClient.this.currentHost != null) {
                            AHessianJmxClient.this.discovery.removeHost(AHessianJmxClient.this.currentHost);
                        }
                        AHessianJmxClient.this.discovery.start();
                    }
                    if (AHessianJmxClient.this._disconnectListener != null) {
                        AHessianJmxClient.this._disconnectListener.run();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void run(Channel channel) {
            }
        });
        this.client.connectedListener(new HessianRPCServiceHandler.ConnectListener(){

            public void run() {
                AHessianJmxClient.this.doConnected();
            }

            public void run(Channel channel) {
            }
        });
        if (this._port == 0) {
            this.discovery = new DiscoveryClient();
            this.discovery.setName(this._discoveryName);
            this.discovery.addListener(new DiscoveryListener(){

                public void newHost(String name, String host) {
                    try {
                        String[] x = host.split("&");
                        int port = Integer.parseInt(x[2]);
                        String hostName = x[1];
                        AHessianJmxClient.this.client.setRemoteAddress(hostName, port);
                        AHessianJmxClient.this.client.start();
                        AHessianJmxClient.this.discovery.stop();
                        AHessianJmxClient.this.currentHost = host;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.discovery.init();
            this.discovery.start();
        } else {
            this.client.setRemoteAddress("127.0.0.1", this._port);
            this.client.start();
        }
    }

    public MBeanServerConnection getMBeanServer() {
        while (this.mbeanServer == null && !this.stop) {
            this.lock.lock();
            try {
                this.connected.await(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.lock.unlock();
        }
        return this.mbeanServer;
    }

    public void close() {
        this.client.close();
    }

    public void open() {
        this.client.unblock();
    }

    public void stop() {
        this.stop = true;
    }

    public static void main(String[] args) throws Exception {
        AHessianJmxClient _ahessianClient = new AHessianJmxClient("test", 15009, false, null);
        _ahessianClient.start();
        MBeanServerConnection jmxc = _ahessianClient.getMBeanServer();
        MBeanServerDelegateMBean proxy = MBeanServerInvocationHandler.newProxyInstance(jmxc, new ObjectName("JMImplementation:type=MBeanServerDelegate"), MBeanServerDelegateMBean.class, false);
        System.out.println(proxy.getMBeanServerId());
        boolean ok = false;
        while (true) {
            try {
                while (true) {
                    System.out.println(proxy.getMBeanServerId());
                    ok = true;
                    Thread.sleep(1000L);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Thread.sleep(1000L);
                continue;
            }
            break;
        }
    }

    public void setConnectListener(Runnable connectListener) {
        this._connectListener = connectListener;
    }

    public void setDisconnectListener(Runnable disconnectListener) {
        this._disconnectListener = disconnectListener;
    }
}

