/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constraint;

import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.ColumnData;
import docking.widgets.table.constraint.provider.EditorProvider;
import docking.widgets.table.constrainteditor.ColumnConstraintEditor;
import java.util.Objects;

public abstract class SingleValueColumnConstraint<T>
implements ColumnConstraint<T> {
    protected final String name;
    private T constraintValue = null;
    protected EditorProvider<T> editorProvider;
    private String group;

    protected SingleValueColumnConstraint(String name, T constraintValue, EditorProvider<T> editorProvider, String group) {
        this.name = name;
        this.constraintValue = constraintValue;
        this.editorProvider = editorProvider;
        this.group = group;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public final T getConstraintValue() {
        return this.constraintValue;
    }

    public abstract SingleValueColumnConstraint<T> copy(T var1);

    @Override
    public ColumnConstraintEditor<T> getEditor(ColumnData<T> columnDataSource) {
        return this.editorProvider.getEditor(this, columnDataSource);
    }

    @Override
    public String getConstraintValueString() {
        return this.editorProvider.toString(this.constraintValue);
    }

    @Override
    public ColumnConstraint<T> parseConstraintValue(String newValue, Object dataSource) {
        return this.copy(this.editorProvider.parseValue(newValue, dataSource));
    }

    @Override
    public Class<T> getColumnType() {
        T t = this.getConstraintValue();
        return t.getClass();
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.getConstraintValue());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        SingleValueColumnConstraint otherConstraint = (SingleValueColumnConstraint)o;
        return this.getConstraintValue().equals(otherConstraint.getConstraintValue());
    }
}

