/*
 * Decompiled with CFR 0.152.
 */
package docking.options.editor;

import docking.widgets.button.BrowseButton;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import ghidra.util.filechooser.GhidraFileFilter;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.beans.PropertyEditorSupport;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang3.StringUtils;

public class FileChooserEditor
extends PropertyEditorSupport {
    private static final int NUMBER_OF_COLUMNS = 20;
    private File currentFileValue;
    private JTextField textField = new JTextField(20);
    private File currentDir;
    private GhidraFileChooser fileChooser;
    private GhidraFileFilter fileFilter;
    private MouseListener otherMouseListener;

    public FileChooserEditor() {
        this(null);
    }

    public FileChooserEditor(GhidraFileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    @Override
    public String getAsText() {
        return this.textField.getText().trim();
    }

    @Override
    public Object getValue() {
        String text = this.getAsText();
        if (StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        return new File(text);
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null || text.trim().isEmpty()) {
            this.currentFileValue = null;
            this.textField.setText("");
            return;
        }
        this.currentFileValue = new File(text);
        this.textField.setText(text);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.currentFileValue = null;
            this.textField.setText("");
        } else if (value instanceof File) {
            this.currentFileValue = (File)value;
            this.textField.setText(this.currentFileValue.getAbsolutePath());
        } else if (value instanceof String) {
            String s = (String)value;
            this.setAsText(s);
        }
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return new FileChooserPanel();
    }

    void setMouseListener(MouseListener listener) {
        this.otherMouseListener = listener;
    }

    private class FileChooserPanel
    extends JPanel {
        private JButton browseButton;

        private FileChooserPanel() {
            BoxLayout bl = new BoxLayout(this, 0);
            this.setLayout(bl);
            FileChooserEditor.this.textField.setText(FileChooserEditor.this.currentFileValue != null ? FileChooserEditor.this.currentFileValue.getAbsolutePath() : "");
            this.browseButton = new BrowseButton();
            this.add(FileChooserEditor.this.textField);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.browseButton);
            this.setBorder(BorderFactory.createEmptyBorder());
            FileChooserEditor.this.textField.addActionListener(e -> FileChooserEditor.this.firePropertyChange());
            FileChooserEditor.this.textField.getDocument().addDocumentListener(new TextListener());
            this.browseButton.addActionListener(e -> this.displayFileChooser());
            if (FileChooserEditor.this.otherMouseListener != null) {
                FileChooserEditor.this.textField.addMouseListener(FileChooserEditor.this.otherMouseListener);
                this.browseButton.addMouseListener(FileChooserEditor.this.otherMouseListener);
            }
        }

        private void displayFileChooser() {
            String path;
            if (FileChooserEditor.this.fileChooser == null) {
                this.createFileChooser();
            }
            if ((path = FileChooserEditor.this.textField.getText().trim()).length() != 0) {
                File f = new File(path);
                if (f.isDirectory()) {
                    FileChooserEditor.this.fileChooser.setCurrentDirectory(f);
                } else {
                    File pf = f.getParentFile();
                    if (pf != null && pf.isDirectory()) {
                        FileChooserEditor.this.fileChooser.setSelectedFile(f);
                    }
                }
            }
            FileChooserEditor.this.currentFileValue = FileChooserEditor.this.fileChooser.getSelectedFile();
            if (FileChooserEditor.this.currentFileValue != null) {
                FileChooserEditor.this.textField.setText(FileChooserEditor.this.currentFileValue.getAbsolutePath());
                FileChooserEditor.this.firePropertyChange();
            } else {
                FileChooserEditor.this.currentFileValue = null;
                FileChooserEditor.this.currentDir = FileChooserEditor.this.fileChooser.getCurrentDirectory();
            }
        }

        private void createFileChooser() {
            if (FileChooserEditor.this.fileChooser == null) {
                FileChooserEditor.this.fileChooser = new GhidraFileChooser(this.browseButton);
            }
            FileChooserEditor.this.fileChooser.setApproveButtonText("Choose Path");
            FileChooserEditor.this.fileChooser.setTitle("Choose Path");
            FileChooserEditor.this.fileChooser.setFileSelectionMode(GhidraFileChooserMode.FILES_AND_DIRECTORIES);
            if (FileChooserEditor.this.fileFilter != null) {
                FileChooserEditor.this.fileChooser.setFileFilter(FileChooserEditor.this.fileFilter);
            }
            if (FileChooserEditor.this.currentFileValue != null) {
                FileChooserEditor.this.fileChooser.setSelectedFile(FileChooserEditor.this.currentFileValue);
            } else if (FileChooserEditor.this.currentFileValue != null) {
                File file = FileChooserEditor.this.currentFileValue;
                if (file.exists()) {
                    if (file.isDirectory()) {
                        FileChooserEditor.this.fileChooser.setCurrentDirectory(file);
                    } else {
                        FileChooserEditor.this.fileChooser.setCurrentDirectory(file.getParentFile());
                        FileChooserEditor.this.fileChooser.setSelectedFile(file);
                    }
                } else {
                    File parent = file.getParentFile();
                    if (parent == null) {
                        String homeDir = System.getProperty("user.home");
                        FileChooserEditor.this.fileChooser.setCurrentDirectory(new File(homeDir));
                    }
                    if (parent != null) {
                        FileChooserEditor.this.fileChooser.setCurrentDirectory(parent);
                    }
                }
            } else if (FileChooserEditor.this.currentDir != null) {
                FileChooserEditor.this.fileChooser.setCurrentDirectory(FileChooserEditor.this.currentDir);
            }
        }
    }

    private class TextListener
    implements DocumentListener {
        private TextListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            FileChooserEditor.this.firePropertyChange();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            FileChooserEditor.this.firePropertyChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            FileChooserEditor.this.firePropertyChange();
        }
    }
}

