/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.platform;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import ghidra.app.plugin.core.debug.event.DebuggerPlatformPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.gui.platform.DebuggerSelectPlatformOfferDialog;
import ghidra.app.plugin.core.debug.mapping.DebuggerPlatformOffer;
import ghidra.app.plugin.core.debug.mapping.DebuggerPlatformOpinion;
import ghidra.app.services.DebuggerPlatformService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.debug.api.platform.DebuggerPlatformMapper;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.util.HelpLocation;
import ghidra.util.classfinder.ClassSearcher;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.event.ChangeListener;

@PluginInfo(shortDescription="Debugger platform selection GUI", description="GUI to add, edit, and remove trace platforms", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={TraceActivatedPluginEvent.class, TraceClosedPluginEvent.class, DebuggerPlatformPluginEvent.class}, servicesRequired={DebuggerPlatformService.class})
public class DebuggerPlatformPlugin
extends Plugin {
    @AutoServiceConsumed
    DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    DebuggerPlatformService platformService;
    private final AutoService.Wiring autoServiceWiring;
    private DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    private final ChangeListener classChangeListener = evt -> this.classesChanged();
    protected final DebuggerSelectPlatformOfferDialog offerDialog;
    final Map<Trace, PlatformActionSet> actionsChoosePlatform = new WeakHashMap<Trace, PlatformActionSet>();
    DockingAction actionMore;

    public DebuggerPlatformPlugin(PluginTool tool) {
        super(tool);
        this.autoServiceWiring = AutoService.wireServicesProvidedAndConsumed((Plugin)this);
        this.offerDialog = new DebuggerSelectPlatformOfferDialog(tool);
        ClassSearcher.addChangeListener((ChangeListener)this.classChangeListener);
        this.createActions();
    }

    protected void installActions() {
        Trace trace = this.current.getTrace();
        if (trace == null) {
            return;
        }
        PlatformActionSet actions = this.actionsChoosePlatform.computeIfAbsent(trace, x$0 -> new PlatformActionSet((Trace)x$0));
        actions.updatePlatformOffers();
        actions.mapperActivated(this.platformService.getCurrentMapperFor(trace));
        actions.installActions();
    }

    protected void uninstallActions() {
        PlatformActionSet actions = this.actionsChoosePlatform.get(this.current.getTrace());
        if (actions != null) {
            actions.uninstallActions();
        }
    }

    protected void createActions() {
        this.installActions();
        this.actionMore = (DockingAction)((ActionBuilder)((ActionBuilder)ChooseMorePlatformsAction.builder(this).enabledWhen(ctx -> this.current.getTrace() != null)).onAction(this::activatedChooseMore)).buildAndInstall((Tool)this.tool);
        String[] path = this.actionMore.getMenuBarData().getMenuPath();
        this.tool.setMenuGroup(Arrays.copyOf(path, path.length - 1), "Dbg9. Map Modules/Sections");
        this.tool.contextChanged(null);
    }

    private void activatedChooseMore(ActionContext ctx) {
        long snap;
        if (this.platformService == null) {
            return;
        }
        Trace trace = this.current.getTrace();
        PlatformActionSet actions = this.actionsChoosePlatform.get(trace);
        if (actions == null) {
            return;
        }
        TraceObject object = this.current.getObject();
        DebuggerPlatformOffer offer = this.chooseOffer(trace, object, snap = this.current.getSnap());
        if (offer != null && this.platformService != null) {
            actions.addChosenOffer(offer);
            this.platformService.setCurrentMapperFor(trace, object, offer.take(this.tool, trace), snap);
        }
    }

    private void classesChanged() {
        this.uninstallActions();
        for (PlatformActionSet actions : this.actionsChoosePlatform.values()) {
            actions.updatePlatformOffers();
        }
        this.installActions();
    }

    protected void coordinatesActivated(DebuggerCoordinates coordinates) {
        if (Objects.equals(this.current, coordinates)) {
            return;
        }
        this.uninstallActions();
        this.current = coordinates;
        this.installActions();
        this.tool.contextChanged(null);
    }

    protected void traceClosed(Trace trace) {
        if (trace == this.current.getTrace()) {
            this.coordinatesActivated(DebuggerCoordinates.NOWHERE);
        }
        this.actionsChoosePlatform.remove(trace);
    }

    protected void mapperActivated(Trace trace, DebuggerPlatformMapper mapper) {
        if (trace != this.current.getTrace()) {
            return;
        }
        PlatformActionSet actions = this.actionsChoosePlatform.get(trace);
        if (actions != null) {
            actions.mapperActivated(mapper);
        }
    }

    public void processEvent(PluginEvent event) {
        PluginEvent ev;
        super.processEvent(event);
        if (event instanceof TraceActivatedPluginEvent) {
            ev = (TraceActivatedPluginEvent)event;
            this.coordinatesActivated(ev.getActiveCoordinates());
        }
        if (event instanceof TraceClosedPluginEvent) {
            ev = (TraceClosedPluginEvent)event;
            this.traceClosed(ev.getTrace());
        }
        if (event instanceof DebuggerPlatformPluginEvent) {
            ev = (DebuggerPlatformPluginEvent)event;
            this.mapperActivated(ev.getTrace(), ev.getMapper());
        }
    }

    protected DebuggerPlatformOffer chooseOffer(Trace trace, TraceObject object, long snap) {
        List<DebuggerPlatformOffer> offers = DebuggerPlatformOpinion.queryOpinions(trace, object, snap, true);
        this.offerDialog.setOffers(offers);
        this.tool.showDialog((DialogComponentProvider)this.offerDialog);
        if (this.offerDialog.isCancelled()) {
            return null;
        }
        return this.offerDialog.getSelectedOffer();
    }

    protected class PlatformActionSet {
        private final Trace trace;
        private final Map<DebuggerPlatformOffer, ToggleDockingAction> actions = new LinkedHashMap<DebuggerPlatformOffer, ToggleDockingAction>();

        public PlatformActionSet(Trace trace) {
            this.trace = trace;
        }

        protected Set<DebuggerPlatformOffer> computePlatformOffers(boolean includeOverrides) {
            return new LinkedHashSet<DebuggerPlatformOffer>(DebuggerPlatformOpinion.queryOpinions(this.trace, DebuggerPlatformPlugin.this.current.getObject(), 0L, includeOverrides));
        }

        protected ToggleDockingAction createActionChoosePlatform(DebuggerPlatformOffer offer) {
            ToggleDockingAction action = ((ToggleActionBuilder)((ToggleActionBuilder)ChoosePlatformAction.builder(DebuggerPlatformPlugin.this).menuPath(new String[]{"Debugger", "Choose Platform", offer.getDescription()})).onAction(ctx -> this.activatePlatformOffer(offer))).build();
            String[] path = action.getMenuBarData().getMenuPath();
            DebuggerPlatformPlugin.this.tool.setMenuGroup(Arrays.copyOf(path, path.length - 1), "Dbg9. Map Modules/Sections");
            return action;
        }

        protected void activatePlatformOffer(DebuggerPlatformOffer offer) {
            DebuggerPlatformPlugin.this.platformService.setCurrentMapperFor(this.trace, DebuggerPlatformPlugin.this.current.getObject(), offer.take(DebuggerPlatformPlugin.this.tool, this.trace), DebuggerPlatformPlugin.this.current.getSnap());
        }

        protected void cleanOffers() {
            this.actions.keySet().retainAll(this.computePlatformOffers(true));
        }

        protected void addPreferredOffers() {
            for (DebuggerPlatformOffer offer : this.computePlatformOffers(false)) {
                this.addOfferAction(offer);
            }
        }

        protected void updatePlatformOffers() {
            this.cleanOffers();
            this.addPreferredOffers();
        }

        protected ToggleDockingAction addOfferAction(DebuggerPlatformOffer offer) {
            return this.actions.computeIfAbsent(offer, this::createActionChoosePlatform);
        }

        protected void addChosenOffer(DebuggerPlatformOffer offer) {
            ToggleDockingAction action = this.addOfferAction(offer);
            if (DebuggerPlatformPlugin.this.current.getTrace() == this.trace) {
                DebuggerPlatformPlugin.this.tool.addAction((DockingActionIf)action);
            }
        }

        protected void installActions() {
            for (ToggleDockingAction action : this.actions.values()) {
                DebuggerPlatformPlugin.this.tool.addAction((DockingActionIf)action);
            }
        }

        protected void uninstallActions() {
            for (ToggleDockingAction action : this.actions.values()) {
                DebuggerPlatformPlugin.this.tool.removeAction((DockingActionIf)action);
            }
        }

        protected void mapperActivated(DebuggerPlatformMapper mapper) {
            for (Map.Entry<DebuggerPlatformOffer, ToggleDockingAction> ent : this.actions.entrySet()) {
                DebuggerPlatformOffer offer = ent.getKey();
                ToggleDockingAction action = ent.getValue();
                action.setSelected(mapper != null && offer.isCreatorOf(mapper));
            }
        }
    }

    protected static interface ChooseMorePlatformsAction {
        public static final String NAME = "Choose More Platforms";
        public static final String TITLE = "More...";
        public static final String DESCRIPTION = "Choose from more platforms to use with the current trace";
        public static final String GROUP = "zzzz";
        public static final String HELP_ANCHOR = "choose_more_platforms";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{"Debugger", "Choose Platform", TITLE})).menuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    protected static interface ChoosePlatformAction {
        public static final String NAME = "Choose Platform";
        public static final String DESCRIPTION = "Choose a platform to use with the current trace";
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "choose_platform";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }
}

