/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint;

import java.awt.Color;

public class TaintCTokenHighlighterPalette {
    private Color uninitializedColor = new Color(192, 192, 192);
    private Color[] colors;

    public TaintCTokenHighlighterPalette(int sz) {
        this.colors = new Color[sz];
        this.setGYRColorRange();
    }

    public int getSize() {
        if (this.colors == null) {
            return 0;
        }
        return this.colors.length;
    }

    public Color getDefaultColor() {
        return this.uninitializedColor;
    }

    public Color getColor(int i) {
        if (i < 0 || i >= this.colors.length) {
            return this.uninitializedColor;
        }
        return this.colors[i];
    }

    private void setGYRColorRange() {
        float red = 0.0f;
        float green = 1.0f;
        float blue = 0.0f;
        float step = 1.0f / (float)(this.colors.length - 1) * 10.0f;
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i] = new Color(red, green, blue);
            if ((double)green == 1.0 && (double)red < 1.0) {
                if (!((red += step) > 1.0f)) continue;
                red = 1.0f;
                continue;
            }
            if (!((double)(green -= step) < 0.0)) continue;
            green = 0.0f;
        }
    }
}

