/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.CodeUnitLocation;

public class MnemonicFieldLocation
extends CodeUnitLocation {
    private String mnemonicStr;

    public MnemonicFieldLocation(Program program, Address addr, int[] componentPath, String mnemonicString, int charOffset) {
        this(program, addr, null, componentPath, mnemonicString, charOffset);
    }

    public MnemonicFieldLocation(Program program, Address addr, Address refAddr, int[] componentPath, String mnemonicString, int charOffset) {
        super(program, addr, componentPath, refAddr, 0, 0, charOffset);
        this.mnemonicStr = mnemonicString;
    }

    public MnemonicFieldLocation(Program program, Address address) {
        super(program, address, 0, 0, 0);
    }

    public MnemonicFieldLocation() {
    }

    public String getMnemonic() {
        return this.mnemonicStr;
    }

    @Override
    public String toString() {
        return super.toString() + ", Mnemonic = " + this.mnemonicStr;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.mnemonicStr == null ? 0 : this.mnemonicStr.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MnemonicFieldLocation other = (MnemonicFieldLocation)obj;
        return !(this.mnemonicStr == null ? other.mnemonicStr != null : !this.mnemonicStr.equals(other.mnemonicStr));
    }

    @Override
    public void restoreState(Program p, SaveState obj) {
        super.restoreState(p, obj);
        this.mnemonicStr = obj.getString("_MNEMONIC", "");
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putString("_MNEMONIC", this.mnemonicStr);
    }
}

