/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.disassemble.Disassembler;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public abstract class LanguagePostUpgradeInstructionHandler {
    protected final Program program;
    private Disassembler disassembler;

    public LanguagePostUpgradeInstructionHandler(Program program) {
        this.program = program;
    }

    protected Disassembler getDisassembler() {
        if (this.disassembler == null) {
            this.disassembler = Disassembler.getDisassembler(this.program, TaskMonitor.DUMMY, null);
        }
        return this.disassembler;
    }

    public abstract void fixupInstructions(Language var1, TaskMonitor var2) throws CancelledException;

    protected void modifySingleInstructionContext(Address addr, RegisterValue contextValue, boolean mergeContext) {
        ProgramContext programContext;
        RegisterValue oldRegisterValue;
        Register baseReg = contextValue.getRegister().getBaseRegister();
        if (!baseReg.isProcessorContext()) {
            throw new IllegalArgumentException("Invalid context register: " + baseReg.getName());
        }
        Listing listing = this.program.getListing();
        if (mergeContext && (oldRegisterValue = (programContext = this.program.getProgramContext()).getRegisterValue(baseReg, addr)) != null) {
            contextValue = oldRegisterValue.combineValues(contextValue);
        }
        listing.clearCodeUnits(addr, addr, true);
        this.getDisassembler().disassemble(addr, null, contextValue, true);
    }
}

