/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.lang.CompilerSpecDescription;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.DecompilerLanguage;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.PcodeInjectLibrary;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.DefaultProgramContext;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.pcode.Encoder;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public interface CompilerSpec {
    public static final String CALLING_CONVENTION_unknown = "unknown";
    public static final String CALLING_CONVENTION_default = "default";
    public static final String CALLING_CONVENTION_cdecl = "__cdecl";
    public static final String CALLING_CONVENTION_pascal = "__pascal";
    public static final String CALLING_CONVENTION_thiscall = "__thiscall";
    public static final String CALLING_CONVENTION_stdcall = "__stdcall";
    public static final String CALLING_CONVENTION_fastcall = "__fastcall";
    public static final String CALLING_CONVENTION_vectorcall = "__vectorcall";
    public static final String CALLING_CONVENTION_rustcall = "__rustcall";

    public static boolean isUnknownCallingConvention(String callingConventionName) {
        return StringUtils.isBlank((CharSequence)callingConventionName) || CALLING_CONVENTION_unknown.equals(callingConventionName);
    }

    public Language getLanguage();

    public CompilerSpecDescription getCompilerSpecDescription();

    public CompilerSpecID getCompilerSpecID();

    public Register getStackPointer();

    public boolean isStackRightJustified();

    public AddressSpace getAddressSpace(String var1);

    public AddressSpace getStackSpace();

    public AddressSpace getStackBaseSpace();

    public boolean stackGrowsNegative();

    public void applyContextSettings(DefaultProgramContext var1);

    public PrototypeModel[] getCallingConventions();

    public PrototypeModel getCallingConvention(String var1);

    public PrototypeModel[] getAllModels();

    public PrototypeModel getDefaultCallingConvention();

    public DecompilerLanguage getDecompilerOutputLanguage();

    public PrototypeModel getPrototypeEvaluationModel(EvaluationModelType var1);

    public boolean isGlobal(Address var1);

    public DataOrganization getDataOrganization();

    public PcodeInjectLibrary getPcodeInjectLibrary();

    public PrototypeModel matchConvention(String var1);

    public PrototypeModel findBestCallingConvention(Parameter[] var1);

    public boolean hasProperty(String var1);

    public boolean doesCDataTypeConversions();

    public int getPropertyAsInt(String var1, int var2);

    public boolean getPropertyAsBoolean(String var1, boolean var2);

    public String getProperty(String var1, String var2);

    public String getProperty(String var1);

    public Set<String> getPropertyKeys();

    public void encode(Encoder var1) throws IOException;

    public boolean isEquivalent(CompilerSpec var1);

    public static enum EvaluationModelType {
        EVAL_CURRENT,
        EVAL_CALLED;

    }
}

