/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target;

import db.DBRecord;
import db.LongField;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.TraceObjectValueStorage;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStoreFactory;
import java.lang.reflect.Field;

public class DBTraceObjectDBFieldCodec<OV extends DBAnnotatedObject>
extends DBCachedObjectStoreFactory.AbstractDBFieldCodec<DBTraceObject, OV, LongField> {
    public DBTraceObjectDBFieldCodec(Class<OV> objectType, Field field, int column) {
        super(DBTraceObject.class, objectType, LongField.class, field, column);
    }

    protected static long encode(DBTraceObject value) {
        return value == null ? -1L : value.getKey();
    }

    protected static DBTraceObject decode(TraceObjectValueStorage ent, long enc) {
        return enc == -1L ? null : ent.getManager().getObjectById(enc);
    }

    public void store(DBTraceObject value, LongField f) {
        f.setLongValue(DBTraceObjectDBFieldCodec.encode(value));
    }

    protected void doStore(OV obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
        record.setLongValue(this.column, DBTraceObjectDBFieldCodec.encode((DBTraceObject)this.getValue((DBAnnotatedObject)obj)));
    }

    protected void doLoad(OV obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
        this.setValue((DBAnnotatedObject)obj, DBTraceObjectDBFieldCodec.decode((TraceObjectValueStorage)obj, record.getLongValue(this.column)));
    }
}

