/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.kineticgenerator.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.tile.IKineticSource;
import ic2.api.item.IKineticWindRotor;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotConsumableIKineticWindRotor;
import ic2.core.block.kineticgenerator.container.ContainerWaterKineticGenerator;
import ic2.core.block.kineticgenerator.gui.GuiWaterKineticGenerator;
import java.util.List;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityWaterKineticGenerator
extends TileEntityInventory
implements IKineticSource,
IHasGui {
    private boolean firsttick = true;
    private int updateTicker = IC2.random.nextInt(this.getTickRate());
    public InvSlotConsumableIKineticWindRotor rotorSlot = new InvSlotConsumableIKineticWindRotor(this, "rotorslot", 0, 1);
    public short type = 0;
    private boolean rightFacing;
    private int distanceToNormalBiome;
    private int crossSection;
    private int obstructedCrossSection;
    private int waterFlow;
    private final double efficiencyRollOffExponent = 2.0;
    private static final float outputModifier = 0.2f;
    private float angle = 0.0f;
    private float rotationSpeed;
    private static final float rotationModifier = 0.1f;
    private long lastcheck;

    private int getTickRate() {
        return 20;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.firsttick) {
            this.updateSeaInfo();
            this.firsttick = false;
        }
        if (this.updateTicker++ % this.getTickRate() != 0) {
            return;
        }
        if (this.type == 0) {
            BiomeGenBase biome = this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145849_e);
            this.type = biome == BiomeGenBase.field_76771_b || biome == BiomeGenBase.field_150575_M ? (short)1 : (biome == BiomeGenBase.field_76781_i ? (short)2 : (short)-1);
        }
        if (this.type == -1) {
            return;
        }
        boolean needsInvUpdate = false;
        if (!this.rotorSlot.isEmpty()) {
            if (this.checkSpace(1, true) == 0) {
                if (!this.getActive()) {
                    this.setActive(true);
                    needsInvUpdate = true;
                }
            } else if (this.getActive()) {
                this.setActive(false);
                needsInvUpdate = true;
            }
        } else if (this.getActive()) {
            this.setActive(false);
            needsInvUpdate = true;
        }
        if (this.getActive()) {
            this.crossSection = this.getRotorDiameter() / 2 * 2 * 2 + 1;
            this.crossSection *= this.crossSection;
            this.obstructedCrossSection = this.checkSpace(this.getRotorDiameter() * 3, false);
            if (this.obstructedCrossSection > 0 && this.obstructedCrossSection <= (this.getRotorDiameter() + 1) / 2) {
                this.obstructedCrossSection = 0;
            } else if (this.obstructedCrossSection < 0) {
                this.obstructedCrossSection = this.crossSection;
            }
            int rotordamage = 0;
            if (this.type == 1) {
                float diff = (float)Math.sin((double)this.field_145850_b.func_72820_D() * Math.PI / 6000.0);
                diff *= Math.abs(diff);
                this.rotationSpeed = (float)((double)(diff * (float)this.distanceToNormalBiome / 100.0f) * (1.0 - Math.pow((double)this.obstructedCrossSection / (double)this.crossSection, 2.0)));
                this.waterFlow = (int)(this.rotationSpeed * 3000.0f);
                if (this.rightFacing) {
                    this.rotationSpeed *= -1.0f;
                }
                IC2.network.get().updateTileEntityField(this, "rotationSpeed");
                this.waterFlow = (int)((float)this.waterFlow * this.getefficiency());
                rotordamage = 2;
            } else if (this.type == 2) {
                this.rotationSpeed = Math.max(Math.min(this.distanceToNormalBiome, 20), 50) / 50;
                this.waterFlow = (int)(this.rotationSpeed * 1000.0f);
                if (this.getFacing() == ForgeDirection.EAST.ordinal() || this.getFacing() == ForgeDirection.NORTH.ordinal()) {
                    this.rotationSpeed *= -1.0f;
                }
                IC2.network.get().updateTileEntityField(this, "rotationSpeed");
                this.waterFlow = (int)((float)this.waterFlow * (this.getefficiency() * (1.0f - 0.3f * this.field_145850_b.field_73012_v.nextFloat() - 0.1f * ((float)this.obstructedCrossSection / (float)this.crossSection))));
                rotordamage = 1;
            }
            this.rotorSlot.damage(rotordamage, false);
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    @Override
    public List<String> getNetworkedFields() {
        Vector<String> ret = new Vector<String>(1);
        ret.add("rotationSpeed");
        ret.add("rotorSlot");
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    public int getRotorDiameter() {
        ItemStack stack = this.rotorSlot.get();
        if (stack != null && stack.func_77973_b() instanceof IKineticWindRotor) {
            if (this.type == 1) {
                return ((IKineticWindRotor)stack.func_77973_b()).getDiameter(stack);
            }
            return (((IKineticWindRotor)stack.func_77973_b()).getDiameter(stack) + 1) * 2 / 3;
        }
        return 0;
    }

    public int checkSpace(int length, boolean onlyrotor) {
        int box = this.getRotorDiameter() / 2;
        int lentemp = 0;
        if (onlyrotor) {
            length = 1;
            lentemp = length + 1;
        } else {
            box *= 2;
        }
        ForgeDirection fwdDir = ForgeDirection.VALID_DIRECTIONS[this.getFacing()];
        ForgeDirection rightDir = fwdDir.getRotation(ForgeDirection.DOWN);
        int ret = 0;
        for (int up = -box; up <= box; ++up) {
            int y = this.field_145848_d + up;
            for (int right = -box; right <= box; ++right) {
                boolean occupied = false;
                for (int fwd = lentemp - length; fwd <= length; ++fwd) {
                    int x = this.field_145851_c + fwd * fwdDir.offsetX + right * rightDir.offsetX;
                    int z = this.field_145849_e + fwd * fwdDir.offsetZ + right * rightDir.offsetZ;
                    Block block = this.field_145850_b.func_147439_a(x, y, z);
                    if (block == Blocks.field_150355_j) continue;
                    occupied = true;
                    if (up == 0 && right == 0 && fwd == 0 || !(this.field_145850_b.func_147438_o(x, y, z) instanceof TileEntityWaterKineticGenerator) || onlyrotor) continue;
                    return -1;
                }
                if (!occupied) continue;
                ++ret;
            }
        }
        return ret;
    }

    @Override
    public ContainerBase<?> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerWaterKineticGenerator(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiWaterKineticGenerator((ContainerWaterKineticGenerator)this.getGuiContainer(entityPlayer));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public String func_145825_b() {
        return "Water Kinetic Generator";
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        if (side == 0 || side == 1) {
            return false;
        }
        return this.getFacing() != side;
    }

    @Override
    public void setFacing(short side) {
        super.setFacing(side);
        this.updateSeaInfo();
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void updateSeaInfo() {
        ForgeDirection facing = ForgeDirection.VALID_DIRECTIONS[this.getFacing()];
        for (int i = 1; i < 200; ++i) {
            BiomeGenBase biometmp = this.field_145850_b.func_72807_a(this.field_145851_c + facing.offsetX * i, this.field_145849_e + facing.offsetZ * i);
            if (!this.isValidBiome(biometmp)) {
                this.distanceToNormalBiome = i;
                this.rightFacing = true;
                return;
            }
            biometmp = this.field_145850_b.func_72807_a(this.field_145851_c - facing.offsetX * i, this.field_145849_e - facing.offsetZ * i);
            if (this.isValidBiome(biometmp)) continue;
            this.distanceToNormalBiome = i;
            this.rightFacing = false;
            return;
        }
        this.distanceToNormalBiome = 200;
        this.rightFacing = true;
    }

    public boolean isValidBiome(BiomeGenBase biome) {
        return biome == BiomeGenBase.field_150575_M || biome == BiomeGenBase.field_76771_b || biome == BiomeGenBase.field_76781_i;
    }

    public ResourceLocation getRotorRenderTexture() {
        ItemStack stack = this.rotorSlot.get();
        if (stack != null && stack.func_77973_b() instanceof IKineticWindRotor) {
            return ((IKineticWindRotor)stack.func_77973_b()).getRotorRenderTexture(stack);
        }
        return new ResourceLocation(IC2.textureDomain, "textures/items/rotors/rotorWoodmodel.png");
    }

    public float getAngle() {
        if (this.rotationSpeed != 0.0f) {
            this.angle += (float)(System.currentTimeMillis() - this.lastcheck) * this.rotationSpeed * 0.1f;
            this.angle %= 360.0f;
            this.lastcheck = System.currentTimeMillis();
        }
        return this.angle;
    }

    @Override
    public int maxrequestkineticenergyTick(ForgeDirection directionFrom) {
        return this.getKuOutput();
    }

    @Override
    public int requestkineticenergy(ForgeDirection directionFrom, int requestkineticenergy) {
        if (directionFrom.getOpposite().ordinal() == this.getFacing()) {
            return Math.min(requestkineticenergy, this.getKuOutput());
        }
        return 0;
    }

    public int getKuOutput() {
        if (this.getActive()) {
            return (int)Math.abs((float)this.waterFlow * 0.2f);
        }
        return 0;
    }

    public float getefficiency() {
        ItemStack stack = this.rotorSlot.get();
        if (stack != null && stack.func_77973_b() instanceof IKineticWindRotor) {
            return ((IKineticWindRotor)stack.func_77973_b()).getEfficiency(stack);
        }
        return 0.0f;
    }

    public String getRotorhealth() {
        if (!this.rotorSlot.isEmpty()) {
            return StatCollector.func_74837_a((String)"ic2.WaterKineticGenerator.gui.rotorhealth", (Object[])new Object[]{(int)(100.0f - (float)this.rotorSlot.get().func_77960_j() / (float)this.rotorSlot.get().func_77958_k() * 100.0f)});
        }
        return "";
    }
}

