/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.heatgenerator.tileentity;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityHeatSourceInventory;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.heatgenerator.container.ContainerElectricHeatGenerator;
import ic2.core.block.heatgenerator.gui.GuiElectricHeatGenerator;
import ic2.core.block.invslot.InvSlotConsumable;
import ic2.core.block.invslot.InvSlotConsumableItemStack;
import ic2.core.block.invslot.InvSlotDischarge;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityElectricHeatGenerator
extends TileEntityHeatSourceInventory
implements IHasGui,
IEnergySink {
    private boolean newActive;
    public double energy = 0.0;
    public final int maxEnergy = 10000;
    private boolean addedToEnergyNet = false;
    private float guiChargeLevel;
    public final InvSlotDischarge dischargeSlot;
    public final InvSlotConsumable CoilSlot = new InvSlotConsumableItemStack((TileEntityInventory)this, "CoilSlot", 0, 10, Ic2Items.coil);

    public TileEntityElectricHeatGenerator() {
        this.CoilSlot.setStackSizeLimit(1);
        this.dischargeSlot = new InvSlotDischarge(this, 6, 4);
        this.newActive = false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy = nbttagcompound.func_74769_h("energy");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.energy);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (IC2.platform.isSimulating()) {
            double amount;
            if (10000.0 - this.energy >= 1.0 && (amount = this.dischargeSlot.discharge(10000.0 - this.energy, true)) > 0.0) {
                this.energy += amount;
                this.func_70296_d();
            }
            this.guiChargeLevel = Math.min(1.0f, (float)this.energy / 10000.0f);
        }
        if (this.getActive() != this.newActive) {
            this.setActive(this.newActive);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    @Override
    public String func_145825_b() {
        return "ElectricHeatGenerator";
    }

    public ContainerBase<TileEntityElectricHeatGenerator> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerElectricHeatGenerator(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiElectricHeatGenerator(new ContainerElectricHeatGenerator(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    @Override
    public double getDemandedEnergy() {
        return 10000.0 - this.energy;
    }

    @Override
    public int getSinkTier() {
        return 4;
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.energy >= 10000.0) {
            return amount;
        }
        this.energy += amount;
        return 0.0;
    }

    @Override
    public int FillHeatbuffer(int Bufferspace) {
        if (Bufferspace > 0 && this.energy > (double)this.getmaxHeatEmitpeerTick()) {
            if (Bufferspace >= this.getmaxHeatEmitpeerTick()) {
                this.energy -= (double)this.getmaxHeatEmitpeerTick();
                this.newActive = true;
                return this.getmaxHeatEmitpeerTick();
            }
            this.energy -= (double)Bufferspace;
            this.newActive = true;
            return Bufferspace;
        }
        this.newActive = false;
        return 0;
    }

    @Override
    public int getmaxHeatEmitpeerTick() {
        int counter = 0;
        for (int i = 0; i < this.CoilSlot.size(); ++i) {
            if (this.CoilSlot.get(i) == null) continue;
            counter += 10;
        }
        return counter;
    }

    public final float getChargeLevel() {
        return this.guiChargeLevel;
    }
}

